﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;

class Program
{
    static void Main(string[] args)
    {
        //Automatisches Füllen durch expliziten Konstruktoraufruf mit spezielleren Argumenten
        JA arr = new JA(4, InitJATypes.Random);
        //Manuelles Bedienen der Klasse
        //JA arr = new JA();
        //Random r = new Random();
        //arr.PushArray(5);
        //arr.PushArray(3);
        //arr.PushArray(4);
        //arr.PushArray(1);
        //arr.PushArray(6);

        //for (int i = 0; i < arr.RowCount; i++)
        //{
        //    int elements = arr.GetElementCount(i);

        //    for (int j = 0; j < elements; j++)
        //    {
        //        arr.SetElement(i, j, (float)r.NextDouble());
        //    }
        //}

        //arr.SetElement(1, 2, 2.8f);
        //Ausgabe in Konsole um Eigenschaften zu sehen
        Console.WriteLine("Wir sehen folgende Anzahl an float[] Elementen: {0}!", arr.RowCount);
        Console.WriteLine("Wir sehen folgende Anzahl an float Elementen: {0}!", arr.ElementCount);
        //Nutzen ToString() aus - wurde von uns überschrieben
        Console.WriteLine(arr);
        //Auf Benutzereingabe warten
        Console.Read();
    }
}

//Definition unserer Klasse
class JA
{
    //Unser Standardkonstruktor - soll nur das Array initialisieren
    public JA()
    {
        array = new ArrayList();
    }

    //Ein speziellerer Konstruktor - intitialisiert Array und baut bereits Zeilen ein
    public JA(int RowCount)
    {
        array = new ArrayList();

        for (int i = 0; i < RowCount; i++)
            array.Add(new float[RowCount]);
    }

    //Sehr spezieller Konstruktor - macht selbes wie vorhergehender und könnte die Daten auch
    //als Zufallszahlen einbauen
    public JA(int RowCount, InitJATypes type)
    {
        array = new ArrayList();
        //Zufallsklasse von .NET initialisieren
        Random r = new Random();

        for (int i = 0; i < RowCount; i++)
        {
            float[] f = new float[RowCount];
            array.Add(f);

            if (type == InitJATypes.Random)
            {
                for (int j = 0; j < f.Length; j++)
                    f[j] = (float)r.NextDouble();
            }
        }
    }

    //Funktion um ein (Spalten-)Array dem Zeilenarray hinzuzufügen
    public int PushArray(int length)
    {
        array.Add(new float[length]);
        return array.Count - 1;
    }

    //Ruft den Spaltencount von einer Zeile ab
    public int GetElementCount(int row)
    {
        //Wir wollen sichergehen dass es diese Zeile auch gibt
        if (row < 0 || row > array.Count - 1)
            return 0;

        return (array[row] as float[]).Length;
    }

    //Ruft die Zeilenanzahl ab - ist eine Eigenschaft
    public int RowCount
    {
        //Wir erlauben kein setzen des Wertes (set Fehlt!)
        get { return array.Count; }
    }

    //Wir setzen ein Element
    public void SetElement(int row, int col, float value)
    {
        //Überprüfen ob die Zeile existiert
        if (row < 0 || row > array.Count - 1)
            return;

        //Holen uns das entsprechende float Array dahinter
        float[] temp = array[row] as float[];

        //Überprüfen ob Spalte existiert
        if(col < 0 || col > temp.Length -1)
            return;

        //Setzen den Wert
        temp[col] = value;
    }

    //Ruft die Anzahl aller Elemente ab
    public int ElementCount
    {
        get
        {
            //Eigenschaften werden wie Variablen behandelt aber sind Funktionen
            int l = 0;

            foreach (float[] o in array)
                l += o.Length;

            return l;
        }
    }

    //Unsere Variable dieser Klasse
    ArrayList array;

    //Überschreiben ToString()
    public override string ToString()
    {
        string ausgabe = string.Empty;

        foreach (float[] floats in array)
        {
            foreach (float f in floats)
                ausgabe += f + "\t";

            ausgabe += "\n";
        }

        return ausgabe;
    }
}

//Bauen unsere Konstanten - Empty wird 0 erhalten und Random 1 da wir nichts festlegen
enum InitJATypes
{
    Empty,
    Random,
}
