﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Xml.Serialization;

namespace Vektoren
{
    public class vec
    {
        List<double> entries;

        public vec()
        {
            entries = new List<double>();
        }

        public vec(int length)
            : this()
        {
            for (int i = 0; i < length; i++)
                entries.Add(0.0);
        }

        public vec(vec v)
        {
            for(int i = 0; i < v.Count; i++)
                entries.Add(v[i]);
        }

        public vec(string fileName) : this()
        {
            FileStream fs = null;

            try
            {
                fs = new FileStream(fileName, FileMode.Open, FileAccess.Read);
                XmlSerializer xml = new XmlSerializer(typeof(List<double>));
                entries = xml.Deserialize(fs) as List<double>;
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
        }

        private vec Add(double x)
        {
            entries.Add(x);
            return this;
        }

        public bool Save(string fileName)
        {
            FileStream fs = null;

            try
            {
                fs = new FileStream(fileName, FileMode.Create, FileAccess.Write);
                XmlSerializer xml = new XmlSerializer(typeof(List<double>));
                xml.Serialize(fs, entries);
                return true;
            }
            catch (Exception ex)
            {
                return false;
            }
            finally
            {
                if (fs != null)
                    fs.Close();
            }
        }

        public int Count
        {
            get { return entries.Count; }
        }

        public double this[int index]
        {
            get 
            {
                if (index < 0 || index > Count - 1)
                    return 0.0;

                return entries[index];
            }
            set
            {
                if (index >= 0 && index < Count)
                    entries[index] = value;
            }
        }

        public static vec operator +(vec x, vec y)
        {
            vec v = new vec(Math.Max(x.Count, y.Count));

            for (int i = 0; i < v.Count; i++)
                v[i] = x[i] + y[i];

            return v;
        }

        public static vec operator -(vec x, vec y)
        {
            return x + (-y);
        }

        public static vec operator -(vec x)
        {
            vec v = new vec(x);

            for (int i = 0; i < v.Count; i++)
                v[i] = -v[i];

            return v;
        }

        public static implicit operator vec(double x)
        {
            return new vec().Add(x);
        }

        public static explicit operator double(vec x)
        {
            double sum = 0.0;

            for(int i = 0; i < x.Count; i++)
                sum += x[i] * x[i];

            return Math.Sqrt(sum);
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();

            sb.Append("Vektor mit Länge ").Append(Count).AppendLine(":");

            for (int i = 0; i < Count; i++)
                sb.Append(this[i]).Append(" ");

            return sb.ToString();
        }

        public void Randomize()
        {
            Random r = new Random();

            for (int i = 0; i < Count; i++)
                this[i] = r.NextDouble() * 50.0;
        }
    }
}