﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace Fibonacci
{
    public partial class Form1 : Form
    {
        FibItem[] buffer;

        public Form1()
        {
            InitializeComponent();
            buffer = new FibItem[50];
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            int index = 2;
            BigInteger n2 = 0;
            BigInteger n1 = 1;

            while (!backgroundWorker1.CancellationPending && index < 10000)
            {
                System.Threading.Thread.Sleep(2);
                BigInteger tmp = n1;
                n1 = Fibonacci(n1, n2);
                n2 = tmp;
                backgroundWorker1.ReportProgress(index, n1);
                index++;
            }
        }

        private BigInteger Fibonacci(BigInteger prev, BigInteger prevprev)
        {
            return prev + prevprev;
        }

        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            buffer[(e.ProgressPercentage - 2) % buffer.Length] = new FibItem(e.ProgressPercentage, e.UserState as BigInteger);

            if ((e.ProgressPercentage - 1) % buffer.Length == 0)
            {
                button3.Enabled = true;
                listBox1.Items.AddRange(buffer);
                buffer = new FibItem[buffer.Length];
            }
        }

        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            button1.Enabled = true;
            button2.Enabled = false;

            MessageBox.Show("Ich bin fertig!");
        }

        private void button1_Click(object sender, EventArgs e)
        {
            button1.Enabled = false;
            button2.Enabled = true;
            backgroundWorker1.RunWorkerAsync();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            button1.Enabled = true;
            button2.Enabled = false;
            backgroundWorker1.CancelAsync();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                System.Threading.ParameterizedThreadStart ts = new System.Threading.ParameterizedThreadStart(AsyncSaving);
                System.Threading.Thread t = new System.Threading.Thread(ts);
                t.Start(saveFileDialog1.FileName);
            }
        }

        private void AsyncSaving(object fileName)
        {
            using (StreamWriter sw = new StreamWriter(fileName as string))
            {
                for(int i = 0; i < listBox1.Items.Count; i++)
                    sw.WriteLine(listBox1.Items[i].ToString());

            }
        }
    }
}
