﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.DirectX.DirectSound;

namespace Chat_Programm
{
    static class Audioproperties
    {
        static WaveFormat format;
        static decimal notifySize;
        static decimal captureBufferSize;
        static decimal outputBufferSize;
        static int numberofbuffers = 16;

        public static int Numberofbuffers
        {
            get { return Audioproperties.numberofbuffers; }
            set { Audioproperties.numberofbuffers = value; }
        }

        public static WaveFormat Format
        {
            get { return format; }
            private set { format = value; }
        }

        public static decimal OutputBufferSize
        {
            get { return outputBufferSize; }
            private set { outputBufferSize = value; }
        }

        public static decimal CaptureBufferSize
        {
            get { return captureBufferSize; }
            private set { captureBufferSize = value; }
        }


        public static decimal NotifySize
        {
            get { return notifySize; }
            private set { notifySize = value; }
        }


        static Audioproperties()
        {
            //Audioformat festlegen: mit Wikipedia ;)
            Format = new WaveFormat
          {
              //Abtastrate
              SamplesPerSecond = 96000,
              //Quantisierungsauflösung
              BitsPerSample = 32,
              Channels = 2,
              //Dateiidentifizierung
              FormatTag = WaveFormatTag.Pcm
          };

            //Formeln: http://de.wikipedia.org/wiki/WAV_%28Format%29

            //Framegröße ausrechnen
            format.BlockAlign = (short)(format.Channels * (format.BitsPerSample / 8));
            //Durchschnitt der nötigen Übertragungsbandbreite
            format.AverageBytesPerSecond = format.SamplesPerSecond * format.BlockAlign;
            NotifySize = Math.Max(4096, format.AverageBytesPerSecond / 8);
            NotifySize -= NotifySize % format.BlockAlign;

            //Größe der Buffer festlegen
            CaptureBufferSize = Numberofbuffers * NotifySize;
            OutputBufferSize = Numberofbuffers * NotifySize / 2;
        }

    }
}
