﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Net;
using System.IO;
using System.Threading;
using System.Net.NetworkInformation;
using Microsoft.DirectX.DirectSound;

namespace Chat_Programm
{
    public partial class Form1 : Form
    {
        Thread connectionThread;        // in diesem Thread versucht man sich mit einen server zu verbinden
        Thread connectionsoundThread;   //dito für sound
        Thread empfangenThread;         // In diesem Thread läuft der abhoer mechnismus
        Thread serverStarten;           // in diesem Thread Wird der Server gestarten und auf eine verbindung gewartet
        Thread serversoundStarten;      // dito für Sound
        Thread dialogue;                // in diesem Thread wird die AudioVerbindung erstellt
        Client client1;
        Client clientsound;
        String ipadresse;
        public delegate void StateChangedDelegate(string str);
        StateChangedDelegate exc;
        Server server1;
        Server serversound;
        public delegate void AddTextDelegate(string s);
        AddTextDelegate adt;
        Empfangen_Senden e_s;
        TalkListen t_l;
        bool WhoIsTheServer;        // braucht man um zu wissen welchen TcPClient(Server oder Client) ind die Senden-Empfangen Klasse schreibt 
        bool WhoIsTheSoundServer;   // dito aber für Sound
        int indexplay;
        int indexrecord;
        IntPtr handle1;

        public IntPtr Handle1
        {
            get { return handle1; }
            set { handle1 = value; }
        }

        public int Indexrecord
        {
            get { return indexrecord; }
            set { indexrecord = value; }
        }

        public int Indexplay
        {
            get { return indexplay; }
            set { indexplay = value; }
        }

        public Form1()
        {
            InitializeComponent();
            exc = new StateChangedDelegate(Ausgeben);
            adt = new AddTextDelegate(MessageStr);
            e_s = new Empfangen_Senden();
            e_s.MessageReceived += new EventHandler<MessageReceivedEventArgs>(e_s_MessageReceived);
            textboxConStatus.ReadOnly = true;
            empfangenThread = new Thread(e_s.empfangen);
            server1 = new Server();
            server1.Connect += new EventHandler<ConnectEventArg>(server1_Connect);
            server1.ReportState += new EventHandler<ReportStateEventArgs>(server1_ReportState);
            Handle1 = this.Handle;
        }

        void server1_Connect(object sender, ConnectEventArg e) // event dass den empfangenThread aufruft (wird geworfen wenn eine Verbindung Steht)
        {
            buttonSend.Enabled = true;
            e_s.Tcpclient1 = e.Client2;
            empfangenThread.Start();
        }
        #region(Server)


        void server1_ReportState(object sender, ReportStateEventArgs e) // event der meldungen in die texboxConStatus ausgibt
        {
            if (InvokeRequired)
                Invoke(exc, e.Str);
            else
                Ausgeben(e.Str);
        }
        private void buttonServerStart_Click(object sender, EventArgs e)
        {
            buttonServerStop.Enabled = true;
            buttonServerStart.Enabled = false;
            buttonAudioStart.Enabled = true;
            serverStarten = new Thread(server1.ServerStarten);
            int port1 = Int32.Parse(textBoxPort.Text);
            object o = port1;
            serverStarten.Start(o);
            WhoIsTheServer = true;

            //beim Server Start Audio Treiber suchen und in Comboboxen schreiben
            try
            {
                var capdevList = new CaptureDevicesCollection();
                var devList = new DevicesCollection();

                for (int i = 0; i < devList.Count; i++)
                {
                    comboBoxDevicesPlay.Items.Add(devList[i].Description);
                }

                for (int i = 0; i < capdevList.Count; i++)
                {
                    comboBoxDevicesRecord.Items.Add(capdevList[i].Description);
                }
                comboBoxDevicesPlay.SelectedIndex = 0;
                comboBoxDevicesRecord.SelectedIndex = 0;
            }

            catch (Exception ex)
            {
                Ausgeben(ex.Message);

            }
        }

        void e_s_MessageReceived(object sender, MessageReceivedEventArgs e)
        {
            if (InvokeRequired)
                Invoke(adt, e.Str);
            else
                MessageStr(e.Str);
        }
        /// <summary>
        /// Schreibt die empfangende Nachricht in die List box
        /// </summary>
        /// <param name="str">Das ist die Nachricht</param>
        public void MessageStr(string str)
        {
            listBox1.Items.Add("Er/Sie/Es :" + str);
            listBox1.SelectedIndex = listBox1.Items.Count - 1;
            listBox1.SelectedIndex = -1;
        }



        private void buttonServerStop_Click(object sender, EventArgs e)
        {
            buttonSend.Enabled = false;
            buttonServerStop.Enabled = false;
            buttonServerStart.Enabled = true;

            try
            {

                server1.Close();
                server1.Stop();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);

            }

        }


        #endregion

        #region(Client)

        private void buttonstart_Click(object sender, EventArgs e)// Man connected sich zu einen server
        {
            //button2.Enabled = true;
            Button_Connect.Enabled = false;

            try
            {
                var capdevList = new CaptureDevicesCollection();
                var devList = new DevicesCollection();

                for (int i = 0; i < devList.Count; i++)
                {
                    comboBoxDevicesPlay.Items.Add(devList[i].Description);
                }

                for (int i = 0; i < capdevList.Count; i++)
                {
                    comboBoxDevicesRecord.Items.Add(capdevList[i].Description);
                }
                comboBoxDevicesPlay.SelectedIndex = 0;
                comboBoxDevicesRecord.SelectedIndex = 0;
            }

            catch (Exception ex)
            {
                Ausgeben(ex.Message);

            }


            //Ip-Adresse bauen
            string[] ipteile = { textBoxip1.Text, textBoxip2.Text, textBoxip3.Text, textBoxip4.Text };
            ipadresse = String.Join(".", ipteile);
            IPAddress ipadressefinal = IPAddress.Parse(ipadresse);

            client1 = new Client(ipadressefinal, Convert.ToInt32(textBoxPort.Text));
            client1.ReportState += new EventHandler<ReportStateEventArgs>(client1_ReportState);
            e_s.ReportState += new EventHandler<ReportStateEventArgs>(e_s_ReportState);
            client1.Connect += new EventHandler<ConnectEventArg>(client1_Connect);

            //Thread startet Connect der Client Klasse
            connectionThread = new Thread(client1.connecten);
            connectionThread.Start();
            textboxConStatus.ScrollToCaret();
            WhoIsTheServer = false;
        }

        void client1_Connect(object sender, ConnectEventArg e)// event dann den empfangenThread aufruft (wird geworfen wenn eine Verbindung Steht)
        {
            buttonSend.Enabled = true;
            e_s.Tcpclient1 = e.Client2;
            empfangenThread.Start();
        }

        void e_s_ReportState(object sender, ReportStateEventArgs e)// event der meldungen in die texboxConStatus ausgibt 
        {
            if (InvokeRequired)
                Invoke(exc, e.Str);
            else
                Ausgeben(e.Str);
        }

        /// <summary>
        ///  Ist dafür da um in die Untere Text box status mittleiungen zu schreiben, wie z.b. connected..
        /// </summary>
        /// <param name="str">ist der String der Ausgegeben wird</param>
        public void Ausgeben(string str)
        {
            textboxConStatus.Text = str;
        }

        void client1_ReportState(object sender, ReportStateEventArgs e)// event der meldungen in die texboxConStatus ausgibt
        {
            if (InvokeRequired)
                Invoke(exc, e.Str);
            else
                Ausgeben(e.Str);
        }

        private void buttonSend_Click(object sender, EventArgs e)// wir senden dei nachricht zur funktion SEND in Empfangen_Senden
        {
            listBox1.Items.Add("Ich: " + textBoxMessage.Text); // ausgabe der eigenen Nachricht
            try
            {
                if (WhoIsTheServer) // zuweisung des TcpClient (Server oder client)
                    e_s.Tcpclient1 = server1.TcpClient1;
                else
                    e_s.Tcpclient1 = client1.Tcpclient1;
                e_s.Send(textBoxMessage.Text);
                textBoxMessage.Clear();
                //Autoscroll
                listBox1.SelectedIndex = listBox1.Items.Count - 1;
                listBox1.SelectedIndex = -1;
            }
            catch (Exception ex)
            {
                Ausgeben(ex.Message);
                textboxConStatus.ScrollToCaret();
            }
        }

        private void button2_Click(object sender, EventArgs e)// button Disconnect
        {
            Button_Connect.Enabled = true;
            button2.Enabled = false;
            buttonSend.Enabled = false;
            //Client schließen
            //und Ausgabe des ConnectionState
            try
            {
                //Client beenden und ausgeben
                Ausgeben(client1.close());
                textboxConStatus.ScrollToCaret();

            }
            catch (Exception ex)
            {
                Ausgeben(ex.Message);
                textboxConStatus.ScrollToCaret();
            }
        }


        #endregion

        #region(Pinger)

        private void button3_Click(object sender, EventArgs e)//Pingen
        {
            if (client1 == null)
            {
                //Ip-Adresse bauen
                string[] ipteile = { textBoxip1.Text, textBoxip2.Text, textBoxip3.Text, textBoxip4.Text };
                ipadresse = String.Join(".", ipteile);
                IPAddress ipadressefinal = IPAddress.Parse(ipadresse);
                client1 = new Client(ipadressefinal);
            }

            string result = client1.Pinger();
            Ausgeben(result);
            textboxConStatus.ScrollToCaret();
        }
        #endregion

        #region{AudioServer}
        private void buttonAudioStart_Click(object sender, EventArgs e)
        {
            try
            {
                t_l = new TalkListen();

                //Server für Audio erstellen
                serversound = new Server();
                serversound.Connect += new EventHandler<ConnectEventArg>(serversound_Connect);
                serversound.ReportState += new EventHandler<ReportStateEventArgs>(serversound_ReportState);
                buttonAudioStop.Enabled = true;

                //Server Starten
                serversoundStarten = new Thread(serversound.ServerStarten);
                int port1 = Int32.Parse(textBoxAudioPort.Text);
                object o = port1;
                serversoundStarten.Start(o);

                //Le serveur c'est moi :)
                WhoIsTheSoundServer = true;



            }

            catch (Exception ex)
            {
                Ausgeben(ex.Message);
            }
        }

        void serversound_ReportState(object sender, ReportStateEventArgs e)
        {

        }

        void serversound_Connect(object sender, ConnectEventArg e)
        {
            //Thread erstellen und handle und ausgewähltes devices mitgeben
            dialogue = new Thread(t_l.Dialogue);
            object[] ol = { Handle1, Indexplay, Indexrecord, e.Client2 };
            dialogue.Start(ol);
        }

        /// <summary>
        /// Stoppt den AudioServer
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonAudioStop_Click(object sender, EventArgs e)
        {
            try
            {
                serversound.Close();
                serversound.Stop();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        /// <summary>
        /// Startet den ConnectVersuch zu einem Server
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonAudioConnect_Click(object sender, EventArgs e)
        {
            //Ip-Adresse bauen
            string[] ipteile = { textBoxip1.Text, textBoxip2.Text, textBoxip3.Text, textBoxip4.Text };
            ipadresse = String.Join(".", ipteile);
            IPAddress ipadressefinal = IPAddress.Parse(ipadresse);

            int audioport = Convert.ToInt32(textBoxAudioPort.Text);

            clientsound = new Client(ipadressefinal, audioport);
            clientsound.ReportState += new EventHandler<ReportStateEventArgs>(clientsound_ReportState);
            //  t_l.ReportState += new EventHandler<ReportStateEventArgs>(t_l_ReportState);
            clientsound.Connect += new EventHandler<ConnectEventArg>(clientsound_Connect);

            //Thread startet Connect der Client Klasse
            connectionsoundThread = new Thread(clientsound.connecten);
            connectionsoundThread.Start();
            textboxConStatus.ScrollToCaret();
            WhoIsTheSoundServer = false;
        }

        /* void t_l_ReportState(object sender, ReportStateEventArgs e)// event der meldungen in die texboxConStatus ausgibt
         {
             if (InvokeRequired)
                 Invoke(exc, e.Str);
             else
                 Ausgeben(e.Str);
         }*/

        void clientsound_ReportState(object sender, ReportStateEventArgs e)// event der meldungen in die texboxConStatus ausgibt
        {
            if (InvokeRequired)
                Invoke(exc, e.Str);
            else
                Ausgeben(e.Str);
        }

        void clientsound_Connect(object sender, ConnectEventArg e)// event dann den empfangenThread aufruft (wird geworfen wenn eine Verbindung Steht)
        {
            //Thread erstellen und handle und ausgewähltes devices mitgeben
            t_l = new TalkListen();
            dialogue = new Thread(t_l.Dialogue);
            object[] ol = { Handle1, Indexplay, Indexrecord, e.Client2 };
            dialogue.Start(ol);
        }

        private void buttonAudioDisconnect_Clicl(object sender, EventArgs e)
        {

            //Client schließen
            //und Ausgabe des ConnectionState
            try
            {
                //Client beenden und ausgeben
                Ausgeben(clientsound.close());
                textboxConStatus.ScrollToCaret();
            }
            catch (Exception ex)
            {
                Ausgeben(ex.Message);
                textboxConStatus.ScrollToCaret();
            }
        }
        #endregion

        private void comboBoxDevicesPlay_SelectedIndexChanged(object sender, EventArgs e)
        {
            Indexplay = comboBoxDevicesPlay.SelectedIndex;
        }

        private void comboBoxDevicesRecord_SelectedIndexChanged(object sender, EventArgs e)
        {
            Indexrecord = comboBoxDevicesRecord.SelectedIndex;
        }

        private void textBoxMessage_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter && textBoxMessage.TextLength != 0)
            {
                buttonSend_Click(sender, e);
            }
        }
    }
}
