﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Xml;
using System.IO;
using System.Drawing.Printing;

namespace iSkript
{
    public partial class Hauptfenster : Form
    {
        DataTable Lagerbestand;
        DataSet ds = new DataSet();
        Color ursprung;
        Form2 fenster2;
        PrintDocument Dokument = new PrintDocument();
        DataGridViewPrinter drucker;
        string Preis_Warenkorb;
        decimal zwischensumme;
        string text;
        double zwischenwert1;
        double zwischenwert2;
        string pathToFile;


        public Hauptfenster(string _pathToFile)
        {
            pathToFile = _pathToFile;
            InitializeComponent();
            programmstart();
            //Event für das Drucken erstellen
            this.Dokument = new System.Drawing.Printing.PrintDocument();
            this.Dokument.PrintPage += new System.Drawing.Printing.PrintPageEventHandler(this.MyPrintDocument_PrintPage);
            // Event fürs Löschen
            entfernenToolStripMenuItem.Click += new EventHandler(entfernenToolStripMenuItem_Click);


        }

        public void programmstart()
        {
            ds.ReadXml(pathToFile);
            Lagerbestand = ds.Tables["Lagerbestand"];

            DateTime dt = File.GetCreationTime(pathToFile);
            toolStripStatusLabel1.Text = "Letzte Änderung: " + dt.ToString();

            DataGridViewColumn dgvc = new DataGridViewTextBoxColumn();
            dgvc.ValueType = typeof(string);
            dgvc.HeaderText = "Name";
            dgvc.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            dgvc.SortMode = DataGridViewColumnSortMode.Automatic;
            DataGridViewColumn dgvc1 = new DataGridViewTextBoxColumn();
            dgvc1.ValueType = typeof(int);
            dgvc1.HeaderText = "Stück pro Karton";
            dgvc1.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc2 = new DataGridViewTextBoxColumn();
            dgvc2.ValueType = typeof(int);
            dgvc2.HeaderText = "Anzahl Kartons";
            dgvc2.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc3 = new DataGridViewTextBoxColumn();
            dgvc3.ValueType = typeof(int);
            dgvc3.HeaderText = "Anzahl Infostand";
            dgvc3.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc4 = new DataGridViewTextBoxColumn();
            dgvc4.ValueType = typeof(int);
            dgvc4.HeaderText = "Gesamtbestand";
            dgvc4.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc5 = new DataGridViewTextBoxColumn();
            dgvc5.ValueType = typeof(Decimal);
            dgvc5.HeaderText = "Preis";

            dataGridView1.Columns.Add(dgvc);
            dataGridView1.Columns.Add(dgvc1);
            dataGridView1.Columns.Add(dgvc2);
            dataGridView1.Columns.Add(dgvc3);
            dataGridView1.Columns.Add(dgvc4);
            dataGridView1.Columns.Add(dgvc5);

            for (int i = 0; i < Lagerbestand.Rows.Count; i++)
            {
                DataGridViewRow dgvr = new DataGridViewRow();
                dgvr.CreateCells(dataGridView1, Lagerbestand.Rows[i].ItemArray[0].ToString(), int.Parse(Lagerbestand.Rows[i].ItemArray[1].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[2].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[3].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[4].ToString()), (Lagerbestand.Rows[i].ItemArray[5]));
                dataGridView1.Rows.Add(dgvr);
            }

            tabelleschuetzen();
            ursprung = dataGridView1.Columns[5].DefaultCellStyle.BackColor;

            // Check für Lagerbestände
            Checker Neu = new Checker(dataGridView1);
            Neu.check();

        }

        private void dateiToolStripMenuItem_Click(object sender, EventArgs e)
        {

        }


        /// Einlesen einer XML Datei
        private void ausXMLToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DataSet ds = new DataSet();
            string Pfad = string.Empty;

            // Datei auswählen
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            openFileDialog1.Filter = "xml Dateien (*.xml)|*.xml|All files (*.*)|*.*";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                Pfad = openFileDialog1.FileName;
            else return;


            ds.ReadXml(Pfad);
            Lagerbestand = ds.Tables["Lagerbestand"];

            DateTime dt = File.GetCreationTime(pathToFile);
            toolStripStatusLabel1.Text = "Letzte Änderung: " + dt.ToString();


            DataGridViewColumn dgvc = new DataGridViewTextBoxColumn();
            dgvc.ValueType = typeof(string);
            dgvc.HeaderText = "Name";
            dgvc.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc1 = new DataGridViewTextBoxColumn();
            dgvc1.ValueType = typeof(int);
            dgvc1.HeaderText = "Stück pro Karton";
            dgvc1.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc2 = new DataGridViewTextBoxColumn();
            dgvc2.ValueType = typeof(int);
            dgvc2.HeaderText = "Anzahl Kartons";
            dgvc2.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc3 = new DataGridViewTextBoxColumn();
            dgvc3.ValueType = typeof(int);
            dgvc3.HeaderText = "Anzahl Infostand";
            dgvc3.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc4 = new DataGridViewTextBoxColumn();
            dgvc4.ValueType = typeof(int);
            dgvc4.HeaderText = "Gesamtbestand";
            dgvc4.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc5 = new DataGridViewTextBoxColumn();
            dgvc5.ValueType = typeof(Decimal);
            dgvc5.HeaderText = "Preis";

            dataGridView1.Columns.Add(dgvc);
            dataGridView1.Columns.Add(dgvc1);
            dataGridView1.Columns.Add(dgvc2);
            dataGridView1.Columns.Add(dgvc3);
            dataGridView1.Columns.Add(dgvc4);
            dataGridView1.Columns.Add(dgvc5);

            for (int i = 0; i < Lagerbestand.Rows.Count; i++)
            {
                DataGridViewRow dgvr = new DataGridViewRow();
                dgvr.CreateCells(dataGridView1, Lagerbestand.Rows[i].ItemArray[0].ToString(), int.Parse(Lagerbestand.Rows[i].ItemArray[1].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[2].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[3].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[4].ToString()), (Lagerbestand.Rows[i].ItemArray[5]));
                dataGridView1.Rows.Add(dgvr);
            }

            Checker Neu = new Checker(dataGridView1);
            Neu.check();

        }


        private void bestandExportierenPDFToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string Pfad = string.Empty;
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();

            saveFileDialog1.Filter = "xml Dateien (*.xml)|*.xml";

            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
                Pfad = saveFileDialog1.FileName;
            else
                return;

            Speichern(Pfad);


        }




        private void überISkriptToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("iSkript Version 1.0 ");
        }

        // Button Speichern 
        // Speichert aktuell geladene Datatable als XML im Programmordnern
        private void button1_Click(object sender, EventArgs e)
        {

            Speichern();
            Checker Neu = new Checker(dataGridView1);
            Neu.check();
        }

        //Methode die speichert
        private void Speichern()
        {
            DataGridViewRowCollection coll = dataGridView1.Rows;

            DataTable t = new DataTable("Lagerbestand");
            t.Columns.Add("Name");
            t.Columns.Add("Stück pro Karton");
            t.Columns.Add("Anzahl Kartons");
            t.Columns.Add("Bestand Infostand");
            t.Columns.Add("Gesamtbestand");
            t.Columns.Add("Preis");

            foreach (DataGridViewRow item in coll)
            {
                t.Rows.Add(item.Cells[0].Value, item.Cells[1].Value, item.Cells[2].Value, item.Cells[3].Value, item.Cells[4].Value, item.Cells[5].Value);
            }

            t.WriteXml(pathToFile);
            toolStripStatusLabel1.Text = "Letzte Aktualisierung: " + DateTime.Now.ToString();
            tabelleschuetzen();
        }


        //Überladene Speichermethode die einen Pfad übernimmt

        private void Speichern(string Pfad)
        {
            DataGridViewRowCollection coll = dataGridView1.Rows;

            DataTable t = new DataTable("Lagerbestand");
            t.Columns.Add("Name");
            t.Columns.Add("Stück pro Karton");
            t.Columns.Add("Anzahl Kartons");
            t.Columns.Add("Bestand Infostand");
            t.Columns.Add("Gesamtbestand");
            t.Columns.Add("Preis");

            foreach (DataGridViewRow item in coll)
            {
                t.Rows.Add(item.Cells[0].Value, item.Cells[1].Value, item.Cells[2].Value, item.Cells[3].Value, item.Cells[4].Value, item.Cells[5].Value);
            }

            t.WriteXml(Pfad);
            toolStripStatusLabel1.Text = "Letzte Aktualisierung: " + DateTime.Now.ToString();
            tabelleschuetzen();
        }

        // Stellt die Bearbeitbarkeits- und Farbeigenschaften wieder her
        private void tabelleschuetzen()
        {
            dataGridView1.Columns[0].ReadOnly = true;
            dataGridView1.Columns[1].ReadOnly = true;
            dataGridView1.Columns[2].ReadOnly = true;
            dataGridView1.Columns[3].ReadOnly = true;
            dataGridView1.Columns[4].ReadOnly = true;
            dataGridView1.Columns[5].ReadOnly = true;


            dataGridView1.Columns[0].DefaultCellStyle.BackColor = ursprung;
            dataGridView1.Columns[1].DefaultCellStyle.BackColor = ursprung;
            dataGridView1.Columns[2].DefaultCellStyle.BackColor = ursprung;
            dataGridView1.Columns[3].DefaultCellStyle.BackColor = ursprung;
            dataGridView1.Columns[4].DefaultCellStyle.BackColor = ursprung;
            dataGridView1.Columns[5].DefaultCellStyle.BackColor = ursprung;




        }

        private void toolStripStatusLabel1_Click(object sender, EventArgs e)
        {

        }

        // Import aus .csv Datei
        private void ausExcelToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string[][] table = CSVReader.Read(@"C:\Lagerbestand ohne Spalten.csv");
            Lagerbestand = CSVReader.ErzeugeTabelle(table);

            for (int i = 0; i < table.Length; i++)
            {
                string[] table1 = table[i];
                Lagerbestand.LoadDataRow(table1, true);
            }

            DataGridViewColumn dgvc = new DataGridViewTextBoxColumn();
            dgvc.ValueType = typeof(string);
            dgvc.HeaderText = "Name";
            dgvc.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            dgvc.SortMode = DataGridViewColumnSortMode.Automatic;
            DataGridViewColumn dgvc1 = new DataGridViewTextBoxColumn();
            dgvc1.ValueType = typeof(int);
            dgvc1.HeaderText = "Stück pro Karton";
            dgvc1.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc2 = new DataGridViewTextBoxColumn();
            dgvc2.ValueType = typeof(int);
            dgvc2.HeaderText = "Anzahl Kartons";
            dgvc2.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc3 = new DataGridViewTextBoxColumn();
            dgvc3.ValueType = typeof(int);
            dgvc3.HeaderText = "Anzahl Infostand";
            dgvc3.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc4 = new DataGridViewTextBoxColumn();
            dgvc4.ValueType = typeof(int);
            dgvc4.HeaderText = "Gesamtbestand";
            dgvc4.AutoSizeMode = DataGridViewAutoSizeColumnMode.AllCells;
            DataGridViewColumn dgvc5 = new DataGridViewTextBoxColumn();
            dgvc5.ValueType = typeof(Decimal);
            dgvc5.HeaderText = "Preis";

            dataGridView1.Columns.Add(dgvc);
            dataGridView1.Columns.Add(dgvc1);
            dataGridView1.Columns.Add(dgvc2);
            dataGridView1.Columns.Add(dgvc3);
            dataGridView1.Columns.Add(dgvc4);
            dataGridView1.Columns.Add(dgvc5);

            for (int i = 0; i < Lagerbestand.Rows.Count; i++)
            {
                DataGridViewRow dgvr = new DataGridViewRow();
                dgvr.CreateCells(dataGridView1, Lagerbestand.Rows[i].ItemArray[0].ToString(), int.Parse(Lagerbestand.Rows[i].ItemArray[1].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[2].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[3].ToString()), int.Parse(Lagerbestand.Rows[i].ItemArray[4].ToString()), (Lagerbestand.Rows[i].ItemArray[5]));
                dataGridView1.Rows.Add(dgvr);
            }
        }


        //FAQ PDF laden
        private void versionToolStripMenuItem_Click(object sender, EventArgs e)
        {
            /* System.Diagnostics.Process.Start(Pfad);*/

        }



        // Anpassen der Preise
        private void preiseÄndernToolStripMenuItem_Click(object sender, EventArgs e)
        {
            dataGridView1.Columns[5].ReadOnly = false;

            Checker neu = new Checker(dataGridView1);
            neu.uncheck();

            dataGridView1.Columns[5].DefaultCellStyle.BackColor = System.Drawing.Color.CornflowerBlue;



        }

        // Verändern aller Stückzahlenwerte möglich
        private void stückzahlenÄndernToolStripMenuItem_Click(object sender, EventArgs e)
        {
            dataGridView1.Columns[1].ReadOnly = false;
            dataGridView1.Columns[2].ReadOnly = false;
            dataGridView1.Columns[3].ReadOnly = false;
            dataGridView1.Columns[4].ReadOnly = false;

            Checker neu = new Checker(dataGridView1);
            neu.uncheck();


            dataGridView1.Columns[1].DefaultCellStyle.BackColor = System.Drawing.Color.CornflowerBlue;
            dataGridView1.Columns[2].DefaultCellStyle.BackColor = System.Drawing.Color.CornflowerBlue;
            dataGridView1.Columns[3].DefaultCellStyle.BackColor = System.Drawing.Color.CornflowerBlue;
            dataGridView1.Columns[4].DefaultCellStyle.BackColor = System.Drawing.Color.CornflowerBlue;



        }


        // eine neue Zeile hinzufügen
        private void hinzufügenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (Application.OpenForms["Form2"] == null)
            {
                fenster2 = new Form2();
                fenster2.SkriptErstellt += new EventHandler(fenster2_SkriptErstellt);
                fenster2.Show();
            }
            else
                Application.OpenForms["Form2"].BringToFront();
        }

        void fenster2_SkriptErstellt(object sender, EventArgs e)
        {
            DataGridViewRow dgvr = new DataGridViewRow();
            dgvr.CreateCells(dataGridView1, fenster2.NeuName, fenster2.NeuKarton1, fenster2.NeuKarton2, fenster2.NeuAnzInfo, fenster2.NeuGesamt, fenster2.NeuPreis);
            dataGridView1.Rows.Add(dgvr);
            // Nach Einfügen gleich Sortieren
            dataGridView1.Sort(dataGridView1.Columns.GetFirstColumn(DataGridViewElementStates.Displayed), ListSortDirection.Ascending);
            // Und Speichern
            Speichern();

        }

        // Drucken Setup
        private bool SetupThePrinting()
        {
            PrintDialog MyPrintDialog = new PrintDialog();
            MyPrintDialog.AllowCurrentPage = false;
            MyPrintDialog.AllowPrintToFile = false;
            MyPrintDialog.AllowSelection = false;
            MyPrintDialog.AllowSomePages = false;
            MyPrintDialog.PrintToFile = false;
            MyPrintDialog.ShowHelp = false;
            MyPrintDialog.ShowNetwork = false;

            if (MyPrintDialog.ShowDialog() != DialogResult.OK)
                return false;

            Dokument.DocumentName = "Skriptenübersicht";
            Dokument.PrinterSettings = MyPrintDialog.PrinterSettings;
            Dokument.DefaultPageSettings = MyPrintDialog.PrinterSettings.DefaultPageSettings;
            Dokument.DefaultPageSettings.Margins = new Margins(40, 40, 40, 40);

            if (MessageBox.Show("Soll die Seite zentriert werden?",
                "InvoiceManager - Center on Page", MessageBoxButtons.YesNo,
                MessageBoxIcon.Question) == DialogResult.Yes)
                drucker = new DataGridViewPrinter(dataGridView1,
                Dokument, true, true, "Skriptenübersicht", new Font("Tahoma", 18,
                FontStyle.Bold, GraphicsUnit.Point), Color.Black, true);
            else
                drucker = new DataGridViewPrinter(dataGridView1,
                Dokument, false, true, "Skriptenübersicht", new Font("Tahoma", 18,
                FontStyle.Bold, GraphicsUnit.Point), Color.Black, true);

            return true;
        }



        //falls es mehrere Seitens ind
        private void MyPrintDocument_PrintPage(object sender,
        System.Drawing.Printing.PrintPageEventArgs e)
        {
            bool more = drucker.DrawDataGridView(e.Graphics);
            if (more == true)
                e.HasMorePages = true;
        }

        //Button Drucken
        private void toolStripMenuItem1_Click(object sender, EventArgs e)
        {

            if (SetupThePrinting())
                Dokument.Print();


        }

        private void label2_Click(object sender, EventArgs e)
        {

        }



        private void entfernenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (this.dataGridView1.SelectedRows.Count > 0 &&
             this.dataGridView1.SelectedRows[0].Index !=
             this.dataGridView1.Rows.Count - 1)
            {
                this.dataGridView1.Rows.RemoveAt(this.dataGridView1.SelectedRows[0].Index);
            }


        }

        // Dem Warenkorb hinzufügen 
        private void button2_Click(object sender, EventArgs e)
        {
            ListViewItem neuesitem = new ListViewItem();

            neuesitem.Text = this.dataGridView1.SelectedRows[0].Cells[0].Value.ToString();
            listView1.Items.Add(neuesitem);

            Preis_Warenkorb = this.dataGridView1.SelectedRows[0].Cells[5].Value.ToString();


            this.zwischensumme += decimal.Parse(Preis_Warenkorb);
            string a = zwischensumme.ToString();

            zwischenwert1 = double.Parse(a);
            zwischenwert2 = zwischenwert1 / 100;

            text = string.Format("{0:C}", zwischenwert2);

            if (label3.Text == string.Empty) label3.Text = "Gesamtsumme : " + text;
            else
            {
                label3.Text = "";

                label3.Text = "Gesamtsumme : " + text;
            }

        }

        // Methode zum Entfernen der Elemente der listView1 in der Datagridview
        private void elementeentfernen(ListView listView1)
        {
            int counter = 0;
            int maxcounter = listView1.Items.Count;


            while (counter < maxcounter)
            {
                foreach (DataGridViewRow row in dataGridView1.Rows)
                {

                    if (counter < maxcounter)
                    {
                        if (row.Cells[0].Value.ToString().Equals(listView1.Items[counter].Text))
                        {
                            counter++;
                            int zwischen = int.Parse(row.Cells[4].Value.ToString());
                            zwischen--;
                            row.Cells[4].Value = zwischen;

                            int zwischen2 = int.Parse(row.Cells[3].Value.ToString());
                            zwischen2--;
                            row.Cells[3].Value = zwischen2;
                        }
                    }

                }
            }

            Speichern();
            listView1.Clear();
            counter = 0;
            maxcounter = 0;
            zwischenwert1 = 0;
            zwischenwert2 = 0;
            text = string.Empty;
            label3.Text = "Gesamtsumme : ";
            zwischensumme = 0;


        }


        // Aus Bestand entfernen Button
        private void button3_Click(object sender, EventArgs e)
        {
            elementeentfernen(listView1);
        }

        //Warenkorb wieder löschen
        private void button4_Click(object sender, EventArgs e)
        {

            Speichern();
            listView1.Clear();
            zwischenwert1 = 0;
            zwischenwert2 = 0;
            text = string.Empty;
            label3.Text = "Gesamtsumme : ";
            zwischensumme = 0;

        }



        private void label3_Click(object sender, EventArgs e)
        {

        }



        private void listView1_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void listBox2_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void listBox3_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void listView2_SelectedIndexChanged(object sender, EventArgs e)
        {

        }











    }
}
