﻿using System;

namespace ProjectKraehwinkel
{
    enum Waren
    {
        Holz, 
        Nahrung, 
        Erz, 
        Bretter, 
        Schnaps, 
        Eisen,
        Anzahl
    }
    
    class Markt
    {
       public int[] Lager;
        
        //Später: Bedarf und Preis mit tollen Formeln berechnen
        //int[] Bedarf;

       public int[] Preis;

        public Markt()
        {
            Lager = new int[(int)Waren.Anzahl];
            Preis = new int[(int)Waren.Anzahl];
            for (int i = 0; i < Lager.Length; i++)
            {
                Lager[i] = 10;
                Preis[i] = 10;
            }
        }

        public void BedarfAbziehen(int Bevoelkerung)
        {
            for (int i = 0; i < Lager.Length; i++)
            {
                if (Lager[i] < Bevoelkerung / 20)
                    Lager[i] = 0;
                else
                    Lager[i] -= Bevoelkerung / 20;
            }
        }

        public void Preiseberechnen(int Bevoelkerung)
        {
            for (int i = 0; i < Preis.Length; i++)
            {                    
                    Preis[i] =  20 - (int) (( (double)Bevoelkerung / 20.0) * 0.02 * (double)Lager[i]);

                    if (Preis[i] <= 0)
                        Preis[i] = 1;
            }

        }

        public int AnMarktVerkaufen(Waren ware, int Stueckzahl)
        {
            Lager[(int)ware] += Stueckzahl;
            return Stueckzahl * Preis[(int)ware];
        }

        public int WarenVomMarktKaufen(Waren ware, int Stueckzahl)
        {
            if (Lager[(int)ware] >= Stueckzahl)
            {
                Lager[(int)ware] -= Stueckzahl;
                return -Stueckzahl * Preis[(int)ware];
            }
            else
            {
                return 0;
            }
        }

        //erzeugt fluktuation 
        public void fluktuation()
        {
            Random rand;
            rand = new Random();
            for (int i = 0; i < Lager.Length; i++)
            {
                 Lager[i] += rand.Next(50) - 10;

                 if (Lager[i] < 0)
                     Lager[i] = 0;
            }

            Lager[(int)Waren.Erz] += 20;
            Lager[(int)Waren.Holz] += 20;
            Lager[(int)Waren.Schnaps] += 20;
            Lager[(int)Waren.Bretter] -= 30;
            Lager[(int)Waren.Eisen] -= 30;
            Lager[(int)Waren.Nahrung] -= 30;

            for (int i = 0; i < Lager.Length; i++)
            {
                if (Lager[i] > 200)
                    Lager[i] = 10;
                if (Lager[i] < 0)
                    Lager[i] = 0;
            }
        }
    }
}
