﻿using System;
using System.Drawing;

using SdlDotNet.Graphics;

namespace ProjectKraehwinkel
{
    enum MenueAnzeige
    {
        Markt, Kirche, Bauflaeche, Wohnung, Fabrik
    }

    class Menue
    {
       public Size MenueSize;
       public  MenueAnzeige Aktuell;
        SdlDotNet.Graphics.Font font;
        Stadt stadt;
        Spielfeld spielfeld;

        public Menue(Size menueSize,Stadt stadt, Spielfeld spielfeld)
        {
            MenueSize = menueSize;
            Aktuell = MenueAnzeige.Bauflaeche;
                font = new SdlDotNet.Graphics.Font(grafic.arial, 12);
            this.stadt = stadt;
            this.spielfeld = spielfeld;
        }

        public Surface draw()
        {
            Surface MenueSur = new Surface(MenueSize);
            MenueSur.Fill(Color.Blue);

            switch (Aktuell)
            {
                case MenueAnzeige.Markt:
                    {
                        Surface Text;
                        Text = font.Render("Willkommen im Markt", Color.Yellow);
                        MenueSur.Blit(Text, new Point(20, 5));

                        for (int i = 0; i < stadt.markt.Lager.Length; i++)
                        {
                            Text = font.Render((Enum.GetNames(typeof(Waren))[i] + ":" + stadt.markt.Lager[i]), Color.Yellow);
                            MenueSur.Blit(Text,new Point(20,20*i+25));
                            Text = font.Render(("Preis:" + stadt.markt.Preis[i]), Color.Yellow);
                            MenueSur.Blit(Text, new Point (100, 20 * i + 25));
                        }
                        break;
                    }

                case MenueAnzeige.Wohnung:
                    {
                        Wohnung Haus;
                        Haus = spielfeld.karte[spielfeld.Selected.X, spielfeld.Selected.Y].inhalt as Wohnung;

                        Surface Text;
                        Text = font.Render("Hier wohnen  " + Haus.bewohner + " Leute", Color.Yellow);
                        MenueSur.Blit(Text, new Point(20, 5));

                        break;
                    }

                case MenueAnzeige.Bauflaeche:
                    {

                        Surface Text;
                        if (spielfeld.stadt.spieler.Vermoegen >= 10000)
                        {
                            Text = font.Render("Hier könnte gebaut werden", Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 5));
                        }
                        else
                        {
                            Text = font.Render("Es fehlt das Geld um zu Bauen", Color.Red);
                            MenueSur.Blit(Text, new Point(20, 5));
                        }

                        Text = new Surface(grafic.Saegewerk);
                        MenueSur.Blit(Text, new Point(20, 25));

                        Text = font.Render("Saegewerk", Color.Yellow);
                        MenueSur.Blit(Text, new Point(80, 25));

                        Text = new Surface(grafic.Eisenschmelze);
                        MenueSur.Blit(Text, new Point(20, 75));

                        Text = font.Render("Eisenschmelze", Color.Yellow);
                        MenueSur.Blit(Text, new Point(80, 75));

                        Text = new Surface(grafic.Bauernhof);
                        MenueSur.Blit(Text, new Point(20, 125));

                        Text = font.Render("Bauernhof", Color.Yellow);
                        MenueSur.Blit(Text, new Point(80, 125));


                        
                        break;
                    }

                case MenueAnzeige.Fabrik:
                    {
                        Fabrik fabrik;
                        fabrik = spielfeld.karte[spielfeld.Selected.X,spielfeld.Selected.Y].inhalt as Fabrik;

                        //Später mit einer GetInfo-Methode für Gebaeude überarbeiten.

                        if (fabrik.gebaedeart == Gebaeudearten.Bauernhof)
                        {
                            Surface Text;
                            Text = font.Render("Dies ist ein Bauernhof", Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 5));
                            Text = font.Render("Besitzer: "+fabrik.Besitzer.name, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 25));
                            Text = font.Render("Produktion: " + fabrik.Produziert, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 45));
                            Text = font.Render("Verbrauch: " + fabrik.Verbraucht, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 65));
                        }

                        if (fabrik.gebaedeart == Gebaeudearten.Eisenschelze)
                        {
                            Surface Text;
                            Text = font.Render("Dies ist eine Eisenschmelze", Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 5));
                            Text = font.Render("Besitzer: " + fabrik.Besitzer.name, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 25));
                            Text = font.Render("Produktion: " + fabrik.Produziert, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 45));
                            Text = font.Render("Verbrauch: " + fabrik.Verbraucht, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 65));
                        }

                        if (fabrik.gebaedeart == Gebaeudearten.Saegewerk)
                        {
                            Surface Text;
                            Text = font.Render("Dies ist ein Sägewerk", Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 5));
                            Text = font.Render("Besitzer: " + fabrik.Besitzer.name, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 25));
                            Text = font.Render("Produktion: " + fabrik.Produziert, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 45));
                            Text = font.Render("Verbrauch: " + fabrik.Verbraucht, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 65));
                        }

                        if (fabrik.gebaedeart == Gebaeudearten.Schnapsbrennerei)
                        {
                            Surface Text;
                            Text = font.Render("Dies ist eine Schnapsbrennerei", Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 5));
                            Text = font.Render("Besitzer: " + fabrik.Besitzer.name, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 25));
                            Text = font.Render("Produktion: " + fabrik.Produziert, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 45));
                            Text = font.Render("Verbrauch: " + fabrik.Verbraucht, Color.Yellow);
                            MenueSur.Blit(Text, new Point(20, 65));
                        }
                        break;
                    }

                case MenueAnzeige.Kirche:
                    {
                        Surface Text = font.Render("Halleluja", Color.Yellow);
                        MenueSur.Blit(Text, new Point(50, 50));
                        break;
                    }
            }

            return MenueSur;
        }

        public void Clicked(int x, int y)
        {
            if (Aktuell == MenueAnzeige.Bauflaeche)
            {
                if (stadt.spieler.Vermoegen >= 10000)
                {
                   
                    if ((x > 20 && x < 70) && (y > 25 && y < 75))
                    {
                        stadt.spieler.Bauen(new Fabrik(spielfeld.Selected, Gebaeudearten.Saegewerk, spielfeld, stadt.spieler));
                        stadt.spieler.Vermoegen -= 10000;
                    }

                    if ((x > 20 && x < 70) && (y > 75 && y < 125))
                    {
                        stadt.spieler.Bauen(new Fabrik(spielfeld.Selected, Gebaeudearten.Eisenschelze, spielfeld, stadt.spieler));
                        stadt.spieler.Vermoegen -= 10000;
                    }

                    if ((x > 20 && x < 70) && (y > 125 && y < 175))
                    {
                        stadt.spieler.Bauen(new Fabrik(spielfeld.Selected, Gebaeudearten.Bauernhof, spielfeld, stadt.spieler));
                        stadt.spieler.Vermoegen -= 10000;
                    }
                }
            }
        }

    }
}
