﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

//voll funktionsfähig, Fehler bei Erstellung von asymmetrischem Feld behoben



namespace Minen
{
    public partial class Form1 : Form
    {
        Minensucher mines;

        int timeelapsed;
        int minesleft;
        bool gamerunning;

        /// <summary>
        /// erstellt neues Spiel, Pfadangabe ist der Programmordner
        /// erzeugt neue Programmoberfläche nach den momentanen Einstellungen des Spiels
        /// </summary>
        public Form1()
        {
            timeelapsed = 0;
            InitializeComponent();

            //über KeyDown definiert, da dann auch Tastenkombinationen möglich
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(ShortCuts);

            mines = new Minensucher(Application.StartupPath);
            mines.InitializeField(mines.Currenteinstellungen);

            InitializeField(mines.Currenteinstellungen);
        }


        #region Erstellung eines neuen Spielfelds nach gegebenen Größenangaben

        /// <summary>
        /// Auslagerung der Initialisierung des Gitters und der Labels
        /// damit einfacher neues Spiel geladen werden kann
        /// Timer ggf stoppen und Laufvariable auf 0 setzen
        /// </summary>
        /// <param name="gd"></param>
        private void InitializeField(GameData gd)
        {
            gamerunning = true;
            if (timer1.Enabled) this.timer1.Stop();

            //Anzeigefelder oben im Spiel initialisieren
            this.timeelapsed = 0;
            this.TimerLabel.Text = timeelapsed.ToString();

            minesleft = gd.Mines;
            this.MinesCounter.Text = minesleft.ToString();


            //Layoutraster erzeugen
            this.tableLayoutPanel1 = new System.Windows.Forms.TableLayoutPanel();

            this.tableLayoutPanel1.ColumnCount = gd.Width;

            for (int i = 2; i < gd.Width; ++i)
            {
                this.tableLayoutPanel1.ColumnStyles.Add(new System.Windows.Forms.ColumnStyle(System.Windows.Forms.SizeType.Absolute, 20f));
            }

            this.tableLayoutPanel1.Location = new System.Drawing.Point(30, 80);

            this.tableLayoutPanel1.RowCount = gd.Height;

            for (int i = 2; i < gd.Height; ++i)
            {
                this.tableLayoutPanel1.RowStyles.Add(new System.Windows.Forms.RowStyle(System.Windows.Forms.SizeType.Absolute, 20f));
            }

            this.tableLayoutPanel1.Size = new System.Drawing.Size(this.tableLayoutPanel1.ColumnCount * 20, this.tableLayoutPanel1.RowCount * 20);
            this.tableLayoutPanel1.TabIndex = 0;


            //dynamische Button/Label-Erzeugung während Laufzeit
            //hier erst einfügen damit Designer weiter funktioniert
            field = new Label[gd.Width][];
            for (int i = 0; i < gd.Width; ++i)
            {
                field[i] = new Label[gd.Height];
                for (int j = 0; j < gd.Height; ++j)
                {
                    this.field[i][j] = new Label();
                }
            }

            for (int i = 0; i < gd.Width; ++i)
                for (int j = 0; j < gd.Height; ++j)
                {
                    try
                    {
                        this.tableLayoutPanel1.Controls.Add(field[i][j], i, j);
                        this.field[i][j].Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom)
                            | System.Windows.Forms.AnchorStyles.Left)
                            | System.Windows.Forms.AnchorStyles.Right)));
                        this.field[i][j].BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
                        this.field[i][j].Location = new System.Drawing.Point(0, 0);
                        this.field[i][j].Margin = new System.Windows.Forms.Padding(0);
                        this.field[i][j].Size = new System.Drawing.Size(20, 20);
                        this.field[i][j].TabIndex = 0;
                        this.field[i][j].Text = mines.StateToString(i, j);
                        this.field[i][j].Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
                        this.field[i][j].MouseClick += new MouseEventHandler(ClickCell);
                        this.field[i][j].TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
                    }
                    catch (Exception e)
                    { Console.WriteLine(e); }
                }

            this.Controls.Add(this.tableLayoutPanel1);
            this.Size = new System.Drawing.Size(this.tableLayoutPanel1.Size.Width + 70, this.tableLayoutPanel1.Size.Height + 150);
        }

        #endregion

        #region Funktionen bei Klick auf Feld

        /// <summary>
        /// setzt Marker auf angeklickte Zelle
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void MarkCell(object sender, MouseEventArgs e)
        {
            int row = tableLayoutPanel1.GetCellPosition(sender as Label).Row;
            int column = tableLayoutPanel1.GetCellPosition(sender as Label).Column;

            if (e.Button == MouseButtons.Right)
            {
                int mark = mines.NextMark(column, row);
                if (mark != -1)
                {
                    setColoredText(this.mines.StateToString(column, row), column, row);
                }
                switch (mark)
                {
                    case 1:
                        minesleft--;
                        this.MinesCounter.Text = minesleft.ToString();
                        break;
                    case 2:
                        minesleft++;
                        this.MinesCounter.Text = minesleft.ToString();
                        break;
                    case 0:
                        break;
                }
            }
        }

        /// <summary>
        /// liest Zelle im Gitter des angeklickten Labels aus
        /// ruft die entsprechenden Funktionen auf für Anklicken einer Zelle
        /// falls Mine erwischt, Auruf von Gameover
        /// beim ersten KLick timer starten
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ClickCell(object sender, MouseEventArgs e)
        {
            if (!timer1.Enabled && gamerunning) timer1.Start();

            //wenn rechtsklick: andere Funktion
            if (e.Button != MouseButtons.Left)
            {
                MarkCell(sender, e);
                return;
            }

            //zeile/spalte des Senders im Gitter manuell auslesen
            int row = tableLayoutPanel1.GetCellPosition(sender as Label).Row;
            int column = tableLayoutPanel1.GetCellPosition(sender as Label).Column;

            //bereits angeklickt
            if (this.mines.Show(column, row)) return;

            if (!this.mines.Clickable(column, row) && !this.mines.Show(column, row)) return;

            int hit = this.mines.Click(column, row);

            setColoredText(this.mines.StateToString(column, row), column, row);
            //this.field[row][column].Text = this.mines.StateToString(row, column);
            this.field[column][row].BorderStyle = BorderStyle.Fixed3D;

            if (hit == -1)
            {
                timer1.Stop();
                GameOver();
            }

            if (hit == 0)
            {
                ClearZeroes(column, row);
            }

            if (this.mines.Counthiddencells == this.mines.Currenteinstellungen.Mines)
            {
                timer1.Stop();
                GameWon();
            }
        }

        /// <summary>
        /// führt klick auf alle Zellen um eine ohne benachbarte Minen aus,
        /// rekursiv um auch mehrere nullen nebeneinander zu erwischen
        /// </summary>
        /// <param name="column">Spalte</param>
        /// <param name="row">Zeile</param>
        private void ClearZeroes(int column, int row)
        {
            for (int i = -1; i < 2; ++i)
            {
                for (int j = -1; j < 2; ++j)
                {
                    try
                    {
                        if (!this.mines.Show(column + i, row + j))
                        {
                            int hit = this.mines.Click(column + i, row + j);
                            setColoredText(this.mines.StateToString(column + i, row + j), column + i, row + j);
                            this.field[column + i][row + j].BorderStyle = BorderStyle.Fixed3D;
                            if (hit == 0) ClearZeroes(column + i, row + j);
                        }
                    }
                    catch (IndexOutOfRangeException) { }
                }
            }
        }

        #endregion

        #region Spiel gewonnen / verloren

        /// <summary>
        /// deaktiviert klicks auf feld, gibt Message aus incl. Highscores der aktuellen Schwierigkeit
        /// wenn neues Spiel: simuliert klick auf new game im menü
        /// </summary>
        private void GameOver()
        {
            mines.Disable();
            gamerunning = false;

            mines.Scores.AddWin(mines.Currenteinstellungen, mines, false);

            string s="Leider verloren, es waren einfach zu viele Minen...\n\n";
            GameEnd ge = new GameEnd(s + mines.Scores.ToString(mines.Currenteinstellungen, mines), false);
            DialogResult dr = ge.ShowDialog();
            if (dr == DialogResult.OK)
                newGameToolStripMenuItem_Click(this, new EventArgs());
            if (dr == DialogResult.No)
                this.Close();
        }

        /// <summary>
        /// deaktiviert klicks auf feld, gibt Message aus incl. Highscores der aktuellen Schwierigkeit
        /// wenn neues Spiel: simuliert klick auf new game im menü
        /// </summary>
        private void GameWon()
        {
            mines.Disable();
            gamerunning = false;
            minesleft = 0;
            MinesCounter.Text = minesleft.ToString();

            mines.Scores.AddWin(mines.Currenteinstellungen, mines, true);

            int place=mines.Scores.NewScore(mines.Currenteinstellungen, mines, timeelapsed);

            string s="Gewonnen!\n\n";

            if (place > 0) s += "Neuer Highscore: Platz " + place + "!\n\n";
            else if (place != -1) s += "Kein neuer Highscore...\n\n";

            GameEnd ge = new GameEnd(s+mines.Scores.ToString(mines.Currenteinstellungen, mines), true);
            DialogResult dr = ge.ShowDialog();
            if (dr == DialogResult.OK)
                newGameToolStripMenuItem_Click(this, new EventArgs());
            if (dr == DialogResult.No)
                this.Close();
        }

        #endregion

        #region Funktionen des Menüs

        /// <summary>
        /// erstellt neues spiel und erstellt oberfläche neu
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void newGameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mines.InitializeField(mines.Currenteinstellungen);
            this.Controls.Remove(tableLayoutPanel1);
            InitializeField(mines.Currenteinstellungen);
        }

        //Felddaten ändern und neues Spiel starten
        private void anfaengerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mines.Currenteinstellungen = mines.Standardeinstellungen[0];
            newGameToolStripMenuItem_Click(this, new EventArgs());
        }

        private void mittelstufeToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mines.Currenteinstellungen = mines.Standardeinstellungen[1];
            newGameToolStripMenuItem_Click(this, new EventArgs());
        }

        private void fortgeschrittenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            mines.Currenteinstellungen = mines.Standardeinstellungen[2];
            newGameToolStripMenuItem_Click(this, new EventArgs());
        }

        //neues Fenster für benutzerdefinierte Eingabe öffnen
        private void benutzerdefiniertToolStripMenuItem_Click(object sender, EventArgs e)
        {
            timer1.Stop();
            UserDefined udef = new UserDefined(mines.Currenteinstellungen);
            udef.SetDesktopLocation(this.DesktopLocation.X + 30, this.DesktopLocation.Y + 30);
            udef.FormClosing += new FormClosingEventHandler(udef_FormClosing);
            udef.ShowDialog();
        }

        void udef_FormClosing(object sender, FormClosingEventArgs e)
        {
            timer1.Start();
            if ((sender as UserDefined).DialogResult == DialogResult.OK)
            {
                mines.Currenteinstellungen = (sender as UserDefined).Gd;
                newGameToolStripMenuItem_Click(this, new EventArgs());
            }
        }

        private void beendenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        //Anleitung anzeigen (Timer wird pausiert)
        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            if (timer1.Enabled) timer1.Stop();
            Manual m = new Manual();
            m.FormClosing += new FormClosingEventHandler(m_FormClosing);
            m.ShowDialog();
        }

        void m_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!timer1.Enabled && mines.Counthiddencells<mines.Currenteinstellungen.Height*mines.Currenteinstellungen.Width)
                timer1.Start();
        }


        #endregion

        #region Farbige Zahlen/Zeichen

        /// <summary>
        /// Zelleninhalt farbig anzeigen
        /// </summary>
        /// <param name="s">Inhalt der Zelle</param>
        /// <param name="x">Spalte</param>
        /// <param name="y">Zeile</param>
        private void setColoredText(String s, int x, int y)
        {
            Color c;
            switch (s)
            {
                case "M":
                    c = Color.DarkRed;
                    break;
                case "!":
                    c = Color.Red;
                    break;
                case "?":
                    c = Color.Blue;
                    break;
                case "1":
                    c = Color.Green;
                    break;
                case "2":
                    c = Color.Orange;
                    break;
                case "3":
                    c = Color.Purple;
                    break;
                case "4":
                    c = Color.Cyan;
                    break;
                case "5":
                    c = Color.Brown;
                    break;
                case "6":
                    c = Color.Lime;
                    break;
                case "7":
                    c = Color.MediumBlue;
                    break;
                case "8":
                    c = Color.Black;
                    break;
                default:
                    c = Color.White;
                    break;
            }

            this.field[x][y].ForeColor = c;
            this.field[x][y].Text = s;
        }

        #endregion
        
        //Timer für Zeitanzeige links oben
        private void timer1_Tick(object sender, EventArgs e)
        {
            timeelapsed++;
            TimerLabel.Text = timeelapsed.ToString();
        }

        //Tastaturshortcuts für Beenden und Neues Spiel
        private void ShortCuts(object sender, KeyEventArgs e)
        {
            if (e.Control && e.KeyCode.Equals(Keys.Q))
                this.Close();
            if (e.KeyCode.Equals(Keys.F2))
                newGameToolStripMenuItem_Click(this, new EventArgs());
        }
        
        //beim Beenden aktuelle Einstellungen und Highscores speichern
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            mines.SaveCurrentGameData(Application.StartupPath);
            mines.SaveHighscores(Application.StartupPath);
        }
    }
}
