﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Minen
{
    /// <summary>
    /// Nebenfenster zur Eingabe benutzerdefinierter Spieldaten
    /// </summary>
    public partial class UserDefined : Form
    {
        GameData gd;

        //gekapselt damit beim Schließen auslesbar
        public GameData Gd
        {
            get { return gd; }
        }

        /// <summary>
        /// Konstruktor für neue benutzerdefinierte Eingabe
        /// </summary>
        /// <param name="data">Anfangsdaten für die Anzeige der NumericUpDown-Felder</param>
        public UserDefined(GameData data)
        {
            gd = new GameData();
            InitializeComponent();
            numericUpDown1.Value = data.Height;
            numericUpDown2.Value = data.Width;
            numericUpDown3.Value = data.Mines;
            this.KeyDown += new System.Windows.Forms.KeyEventHandler(UserDefined_ShortCuts);
            //KeyPreview ist auf true, gibt auch Tastendrücke weiter bei denen UnterControl im Fokus ist
        }

        /// <summary>
        /// übernimmt die eingestellten Werte in die GameData-Variable und schließt das Fenster
        /// </summary>
        private void button1_Click(object sender, EventArgs e)
        {
            gd.Height = (int)numericUpDown1.Value;
            gd.Width = (int)numericUpDown2.Value;
            gd.Mines = (int)numericUpDown3.Value;
            DialogResult = DialogResult.OK;
            this.Close();
        }
        /// <summary>
        /// bricht die Erstellung eines benutzerdefinierten Spiels ab
        /// </summary>
        private void button2_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            this.Close();
        }

        //Anzahl der Minen ist auf 1/4 gedeckelt, dann dauert die Erstellung
        //über Zufallszahlen nicht so lang
        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            numericUpDown3.Maximum = (int)numericUpDown1.Value * (int)numericUpDown2.Value / 4;
        }

        private void numericUpDown2_ValueChanged(object sender, EventArgs e)
        {
            numericUpDown3.Maximum = (int)numericUpDown1.Value * (int)numericUpDown2.Value / 4;
        }

        /// <summary>
        /// erlaubt Bedienung des Fensters über Enter/Esc
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void UserDefined_ShortCuts(object sender, KeyEventArgs e)
        {
            if (e.KeyCode.Equals(Keys.Enter))
                button1_Click(sender, new EventArgs());
            if (e.KeyCode.Equals(Keys.Escape) || e.KeyCode.Equals(Keys.Back))
                button2_Click(sender, new EventArgs());
        }

    }
}
