﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Minen
{
    public partial class GameEnd : Form
    {
        /// <summary>
        /// erzeugt neues Fenster mit Gewinn/Verlustmeldung
        /// Auswahl: neues Spiel, Abbruch, Programm beenden
        /// </summary>
        /// <param name="message">Nachricht die im Popup stehen soll</param>
        /// <param name="win">gewonnen = true, verloren = false</param>
        public GameEnd(string message, bool win)
        {
            InitializeComponent();

            this.KeyDown += new System.Windows.Forms.KeyEventHandler(GameEnd_ShortCuts);

            if (win) this.Text = "Gewonnen!";
            else this.Text = "Leider Verloren";
            this.Message.Text = message;
        }

        private void button2_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            this.Close();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            this.Close();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.No;
            this.Close();
        }

        private void GameEnd_ShortCuts(object sender, KeyEventArgs e)
        {
            if (e.KeyCode.Equals(Keys.Enter))
                button2_Click(this, new EventArgs());
            if (e.KeyCode.Equals(Keys.Escape) || e.KeyCode.Equals(Keys.Back))
                button3_Click(this, new EventArgs());
        }

    }
}
