﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Reflection;

namespace Projekt
{
    public partial class Form1 : Form
    {
        Deck spielDeck, ziehDeck;
        Label labeloben, labellinks, labelrechts;
        int spielerAnzahl;
        List<Spieler> spieler;
        int anDerReihe;
        OptionenForm optionen;
        FarbwunschForm farbwunschform;
        Spielende spielendeform;
        HilfeForm hilfeform;
        Karte.Farben wunschfarbe;
        bool wunsch;
        Random ran;
        int zunehmendeKarten;
        int platzierung;

        public int ZunehmendeKarten
        {
            get { return zunehmendeKarten; }
            set 
            { 
                zunehmendeKarten = value; 
                if(ZunehmendeKarten ==0)
                    toolStripStatusLabelZunehmendeKarten.Text = "";
                else
                    toolStripStatusLabelZunehmendeKarten.Text = "Zu nehmende Karten: " + ZunehmendeKarten.ToString(); 
            }
        }

        public bool Wunsch
        {
            get { return wunsch; }
            set
            {
                wunsch = value;
                if (Wunsch == true && spieler[anDerReihe].KI == true)       //wenn der Gegner sich was wünscht
                    toolStripStatusLabelWunschFarbe.Text = spieler[AnDerReihe].Spielername + " wünscht sich " + Wunschfarbe.ToString() + ".";
                else if(Wunsch==true && spieler[anDerReihe].KI==false)      //wenn man sich selber was wünscht
                    toolStripStatusLabelWunschFarbe.Text = spieler[AnDerReihe].Spielername + " wünschst dir " + Wunschfarbe.ToString() + ".";
                else
                    toolStripStatusLabelWunschFarbe.Text = "";
            }
        }

        public Karte.Farben Wunschfarbe
        {
            get { return wunschfarbe; }
            set { wunschfarbe = value; }
        }

        public int AnDerReihe
        {
            get { return anDerReihe; }
            set 
            {
                if (spieler[AnDerReihe].KartenZahl == 0 && spielDeck.ObersteKarte.Wert != Karte.Werte.A) //wenn der spieler nach seinem zug keine karten mehr hat
                {
                    string tempname=spieler[AnDerReihe].Spielername;
                    bool tempKI=spieler[AnDerReihe].KI;

                    Controls.Remove(spieler[AnDerReihe]);
                    spieler.Remove(spieler[AnDerReihe]);       //spieler entfernen
                    
                    Refresh();
                    spielendeform.Spielergebnis += "\r\n " + platzierung.ToString() + ". " +tempname;
                    platzierung++;
                    if (spieler.Count == 1)                                         //Spiel beendet
                    {
                        spielendeform.Spielergebnis += "\r\n " + platzierung.ToString() + ". " + spieler[0].Spielername;

                        if (spielendeform.ShowDialog() == DialogResult.OK)
                            ToolStripMenuItemNeuesSpiel_Click(this, new EventArgs());
                        else
                            Close();
                    }
                    if (value - AnDerReihe > 1)                             //Fall, dass der fertige Spieler 8 gelegt hat
                        anDerReihe = (value - 1) % spieler.Count;           //da einer aus der Liste entfernt wurde
                    else
                        anDerReihe = anDerReihe % spieler.Count;
                }
                else
                    anDerReihe = value % spieler.Count;             //nächster Spieler

                if (spieler[AnDerReihe].KI)         //falls nächster Spieler ein Computer-Spieler ist
                {
                    spieler[0].Enabled = false;     //Klickbarkeit ausschalten
                    pictureBoxZieh.Enabled = false;
                    toolStripStatusLabelAnDerReihe.Text = spieler[AnDerReihe].Spielername + " ist dran.";
                    timer1.Start();
                }
                else                                //menschlicher spieler
                {
                    Application.DoEvents();
                    spieler[0].Enabled = true;      //Klickbarkeit einschalten
                    pictureBoxZieh.Enabled = true;
                    toolStripStatusLabelAnDerReihe.Text = "Du bist dran.";
                }
            }
        }

        PictureBox pictureBoxSpiel;
        PictureBox pictureBoxZieh;
        Panel panel1;
        
        public Form1()
        {
            InitializeComponent();
            this.SetStyle(ControlStyles.AllPaintingInWmPaint | ControlStyles.UserPaint | ControlStyles.OptimizedDoubleBuffer , true);
            //this.SetStyle(ControlStyles.ResizeRedraw, false);
            DoubleBuffered = true;

            toolStripStatusLabelAnDerReihe.Text = "";
            toolStripStatusLabelWunschFarbe.Text = "";
            toolStripStatusLabelZunehmendeKarten.Text = "";

            ran = new Random();
            optionen = new OptionenForm();
            farbwunschform = new FarbwunschForm();
            StartPosition = FormStartPosition.Manual;
            spielendeform = new Spielende();
            hilfeform = new HilfeForm();
            optionen.ToolStripMenuItemNeuesSpiel_Click += new EventHandler(ToolStripMenuItemNeuesSpiel_Click);
        }
        
        
        public Deck ZiehDeck
        {
            get { return ziehDeck; }
        }

        #region Methoden
        void Decksvertauschen(object sender, EventArgs e)
        {
            Karte temp = spielDeck.ObersteKarte;
            spielDeck.Stapel.Remove(spielDeck.ObersteKarte);
            foreach (Karte karte in spielDeck.Stapel)
            {
                ziehDeck.ablegen(karte);
            }
            spielDeck.Stapel.Clear();
            spielDeck.ablegen(temp);
            if (spielDeck.KartenZahl == 1 && ziehDeck.KartenZahl == 0)              //Allerletzte Karte gezogen -> kein Ziehdeck mehr da
                pictureBoxZieh.Hide();                           
            else
                pictureBoxZieh.Show();
        }


        bool Ablegenerlaubt(Karte karte)
        {
            if (Wunsch)                                                //hat sich jemand eine farbe gewünscht
            {
                if (Wunschfarbe == karte.Farbe || karte.Wert == Karte.Werte.IX)     //passt die karte auf den wunsch
                {
                    return true;                                                      
                }
                else
                {
                    return false;                                                    //wunsch wurde nicht befriedigt und gilt weiterhin
                }
            }
                //normaler zug ohne farbwunsch:
            else if (spielDeck.ObersteKarte.Farbe == karte.Farbe || spielDeck.ObersteKarte.Wert == karte.Wert || karte.Wert == Karte.Werte.IX)
                return true;
            else
                return false;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            timer1.Stop();
            GegnerZug();
        }

        void GegnerZug()
        {
            bool temp = false;
            Karte karte;



            if (spielDeck.ObersteKarte.Wert == Karte.Werte.VII && ZunehmendeKarten > 0)    //vor zug liegt schon 7 auf dem spieldeck
            {
                for (int i = 0; i < spieler[AnDerReihe].KartenZahl; i++)            //ganzes blatt des gegners nach 7 durchgehen 
                {
                    if (spieler[AnDerReihe].Blatt[i].Wert == Karte.Werte.VII)          // 7 gefunden
                    {
                        temp = AblegeVersuch(spieler[AnDerReihe].Blatt[i]);                //7 ablegen
                        ZunehmendeKarten += 2;                                      // der nächste muss 2 mehr nehmen
                        AnDerReihe += 1;                                            //weiter gehts
                        
                        return;                                                     //gegnerzug beendet
                    }
                }

                if (!temp)                                                          //keine 7 im blatt
                {
                    for (int i = 0; i < ZunehmendeKarten; i++)                      //gegner zieht karten
                        spieler[AnDerReihe].KarteZiehen(ziehDeck.ziehen());
                    ZunehmendeKarten = 0;
                }
            }




            for (int i = 0; i < spieler[AnDerReihe].KartenZahl; i++)            //ganzes blatt des gegners durchgehen 
            {
                temp = AblegeVersuch(spieler[anDerReihe].Blatt[i]);               //passt die aktuelle karte???
                if (temp)                                                       //konnte Karte ablegen
                    break;
            }

            if (!temp)                                                          //muss Karte vom Ziehdeck nehmen
            {
                karte = ziehDeck.ziehen();
                spieler[AnDerReihe].KarteZiehen(karte);
                temp = AblegeVersuch(karte);                                           //Versuch, neue Karte abzulegen
            }

            this.Refresh();

            if (temp)                                                               //wenn gegner karte ablegen konnte
            {
                if (spielDeck.ObersteKarte.Wert == Karte.Werte.A)                   //Bei Ass muss man nochmal
                    AnDerReihe += 0;
                else if (spielDeck.ObersteKarte.Wert == Karte.Werte.VIII)           //Bei 8 muss der nächste gegner aussetzen
                    AnDerReihe += 2;
                else if (spielDeck.ObersteKarte.Wert == Karte.Werte.VII && ZunehmendeKarten==0)  //erste 7 auf spieldeck
                {
                    ZunehmendeKarten += 2;                                          //der nächste muss 2 karten nehmen
                    AnDerReihe += 1;                                                //weiter gehts...
                }
                else if (spielDeck.ObersteKarte.Wert == Karte.Werte.IX)
                {
                    if (spieler[AnDerReihe].KartenZahl > 0)
                        Wunschfarbe = spieler[AnDerReihe].Blatt[0].Farbe;
                    else
                        Wunschfarbe = (Karte.Farben)Enum.GetValues(typeof(Karte.Farben)).GetValue(ran.Next(0, 4));
                    Wunsch = true;                                              //ab jetzt wird auf die wunschfarbe überprüft 
                                                                                   //und nicht auf die obenliegende karte...
                    AnDerReihe += 1;                                            //weiter gehts
                }
                else                                                                //normales ende eines zuges
                    AnDerReihe += 1;
            }
            else                        //wenn gegner keine karte ablegen konnte
                AnDerReihe += 1;       //Eigenschaft impliziert einen impliziten Aufruf des Zuges des nächsten Spielers
        }


        bool AblegeVersuch(Karte karte)
        {
            if (Ablegenerlaubt(karte))                                           //jetzt mi oberster spielstapel karte vergleichen
            {
                Wunsch = false;                                                     //wunsch abstellen: für nächsten zug gilt wieder die
                                                                                    // auf dem spieldeck liegende karte
                spieler[AnDerReihe].KarteAblegen(karte);

                spielDeck.ablegen(karte);
                if (ziehDeck.KartenZahl == 0 && spielDeck.KartenZahl == 2)              //rufe decktausch auf, um ziehdeck wieder herzustellen
                    Decksvertauschen(this, new EventArgs());
                pictureBoxSpiel.Image = karte.Bild;

                this.Refresh();                     //alles neu zeichnen

                return true;                                                    //Karte wurde auf Spieldeck gelegt
            }

            return false;                                                       //Karte darf nicht auf Spieldeck
        }

        #endregion

        #region Events

        private void SpielerZug(object sender, KarteEventArgs e)                    //karte aus eigenem blatt angeklickt
        {
            if (ZunehmendeKarten > 0)                                               //Es liegt eine 7 und es müssen Karten genommen werden
            {
                if (e.GewaehlteKarte.Wert == Karte.Werte.VII)                       //wenn man eine 7 auf der Hand hat
                {
                    AblegeVersuch(e.GewaehlteKarte);                                //Sieben ablegen
                    ZunehmendeKarten += 2;                                          //der nächste muss 2 mehr nehmen
                    AnDerReihe += 1;
                    return;
                }
                else                                                                //Karten außer 7 dürfen erst gelegt werden nach Kartenziehen
                    return;
            }

            bool temp=false;
            temp=AblegeVersuch(e.GewaehlteKarte);                                   //passt die gewaehlte karte aufs spieldeck???

            if (temp)                                                               //falls man die gewaehlte karte ablegen konnte
            {
                if (spielDeck.ObersteKarte.Wert == Karte.Werte.A)                   //Bei Ass muss man nochmal
                    AnDerReihe += 0;
                else if (spielDeck.ObersteKarte.Wert == Karte.Werte.VIII)           //Bei 8 muss der nächste gegner aussetzen
                    AnDerReihe += 2;
                else if (spielDeck.ObersteKarte.Wert == Karte.Werte.VII)            //Bei erster 7 auf spieldeck muss der nächste gegner 2 nehmen
                {
                    ZunehmendeKarten += 2;
                    AnDerReihe += 1;
                }
                else if (spielDeck.ObersteKarte.Wert == Karte.Werte.IX)
                {
                    farbwunschform.Location = new Point(this.Location.X + (int)(this.Width - farbwunschform.Width) / 2 + 100, this.Location.Y + (int)(this.Height - farbwunschform.Height) / 2 + 28);   //fenster erscheint mittig
                    if (farbwunschform.ShowDialog() == DialogResult.OK)
                    {
                        Wunschfarbe = farbwunschform.Wunschfarbe;                   //gewünschte farbe aus dem wunschdialog
                        Wunsch = true;                                              //ab jetzt wird auf die wunschfarbe überprüft 
                        //und nicht auf die obenliegende karte...
                        AnDerReihe += 1;                                            //weiter gehts
                    }
                }


                else                                                                  //normales ende eines zuges ohne sonderkarten
                    AnDerReihe += 1;
            }
        }

        private void pictureBoxZieh_Click_1(object sender, EventArgs e)             //ziehstapel angeklickt
        {
            if (ZunehmendeKarten > 0)                                           //es müssen mehrere Karten genommen werden
            {
                for (int i = 0; i < ZunehmendeKarten; i++)                      //menschlicher spieler zieht karten
                    spieler[0].KarteZiehen(ziehDeck.ziehen());
                ZunehmendeKarten = 0;
            }
            else
            {
                Karte karte = ziehDeck.ziehen();
                spieler[0].KarteZiehen(karte);                                          //spieler bekommt die gezogene karte
                if (!Ablegenerlaubt(karte))                                             //wenn man gezogenen karte nicht gleich benutzen kann,
                    AnDerReihe += 1;                                                    //ist der nächste dran
                else
                    pictureBoxZieh.Enabled = false;     //verhindert Ziehen einer zweiten Karte
            }

        }

        //protected override void OnPaint(PaintEventArgs e)
        //{
        //    //base.OnPaint(e);
        //}

        private void toolStripMenuItem3_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void ToolStripMenuItemNeuesSpiel_Click(object sender, EventArgs e)
        {
            #region Controls
            if (spieler!=null)
            foreach (Spieler s in spieler)
                Controls.Remove(s);
            if(panel1!=null)
                Controls.Remove(panel1);
            if (labeloben != null)
                Controls.Remove(labeloben);
            if (labelrechts != null)
                Controls.Remove(labelrechts);
            if (labellinks != null)
                Controls.Remove(labellinks);
            
            spielDeck = new Deck();
            ziehDeck = new Deck(true);
            ziehDeck.Decksvertauschen += new EventHandler(Decksvertauschen);

            panel1 = new Panel();
            Controls.Add(panel1);
            panel1.Size = new Size((int)(2.2 * Karte.Breite), Karte.Hoehe);
            panel1.BackColor = Color.FromArgb(0, Color.Red);
            panel1.Anchor = AnchorStyles.None;
            panel1.Location = new Point((int)((this.Width - panel1.Width) / 2), (int)((this.Height - panel1.Height) / 2));
            

            pictureBoxSpiel = new PictureBox();
            panel1.Controls.Add(pictureBoxSpiel);
            pictureBoxSpiel.Size = new Size(Karte.Breite, Karte.Hoehe);
            pictureBoxSpiel.Location = new Point(0, 0);
            pictureBoxSpiel.SizeMode = PictureBoxSizeMode.StretchImage;
            spielDeck.ablegen(ZiehDeck.ziehen());
            pictureBoxSpiel.Image = spielDeck.ObersteKarte.Bild;

            pictureBoxZieh = new PictureBox();
            panel1.Controls.Add(pictureBoxZieh);
            pictureBoxZieh.Size = new Size(Karte.Breite, Karte.Hoehe);
            pictureBoxZieh.Location = new Point((int)(1.2 * Karte.Breite), 0);
            pictureBoxZieh.SizeMode = PictureBoxSizeMode.StretchImage;
            pictureBoxZieh.Image = KartenBilder.rueckseite;
            pictureBoxZieh.Click += new EventHandler(pictureBoxZieh_Click_1);
            #endregion
            Wunsch = false;                                //falls das spiel mit einer Neun beginnt, wünscht sich niemand etwas!

            if(timer1.Enabled)                             //damit das spiel auch wirklich zu ende ist und die 
                timer1.Stop();                              //gegner nicht direkt weiterspielen können
            ZunehmendeKarten = 0;

            spieler = new List<Spieler>();
            spielerAnzahl = optionen.SpielerAnzahl;
            timer1.Interval = optionen.Wartezeit;
            anDerReihe = 0;
            toolStripStatusLabelAnDerReihe.Text = "Du bist dran.";
            toolStripStatusLabelWunschFarbe.Text = "";
            toolStripStatusLabelZunehmendeKarten.Text = "";
            spielendeform.Spielergebnis = "Ergebnis: \r\n";
            platzierung = 1;

            #region Spieler anlegen
            Spieler ich = new Spieler(false, Spieler.Positionen.unten);
            ich.Size = new System.Drawing.Size(900, 250);
            ich.Location = new System.Drawing.Point(0, 650);
            ich.BackColor = Color.FromArgb(0, Color.Red);
            spieler.Add(ich);
            Spieler gegneroben=null;
            Spieler gegnerlinks=null;
            Spieler gegnerrechts=null;
            labeloben = new Label();
            labelrechts = new Label();
            labellinks = new Label();
            labeloben.AutoSize = true;
            labelrechts.AutoSize = true;
            labellinks.AutoSize = true;
            Controls.Add(labeloben);
            Controls.Add(labelrechts);
            Controls.Add(labellinks);
            labeloben.BackColor = Color.Transparent;
            labelrechts.BackColor = Color.Transparent;
            labellinks.BackColor = Color.Transparent;
            labeloben.Font = new System.Drawing.Font("Microsoft Sans Serif", 16F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            labelrechts.Font = new System.Drawing.Font("Microsoft Sans Serif", 16F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            labellinks.Font = new System.Drawing.Font("Microsoft Sans Serif", 16F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));

            switch (spielerAnzahl)
            {
                case 2:
                    {
                        gegneroben = new Spieler(true, Spieler.Positionen.oben);
                        spieler.Add(gegneroben);
                        break;
                    }
                case 3:
                    {
                        gegnerlinks = new Spieler(true, Spieler.Positionen.links);
                        spieler.Add(gegnerlinks);

                        gegnerrechts = new Spieler(true, Spieler.Positionen.rechts);
                        spieler.Add(gegnerrechts);
                        break;
                    }
                default:
                    {
                        gegnerlinks = new Spieler(true, Spieler.Positionen.links);
                        spieler.Add(gegnerlinks);

                        gegneroben = new Spieler(true, Spieler.Positionen.oben);
                        spieler.Add(gegneroben);

                        gegnerrechts = new Spieler(true, Spieler.Positionen.rechts);
                        spieler.Add(gegnerrechts);
                    }
                    break;
            }

            foreach (Spieler s in spieler)
            {
                s.SpielerZug += new KarteEventHandler(SpielerZug);      
                this.Controls.Add(s);
                s.Init();                                               //5 Karten für jeden
                if (s.KI)
                    s.Spielername = optionen.GegnerName[spieler.IndexOf(s)];        //Spielernamen auslesen
                else
                    s.Spielername = "Du";
            }
                
            if (gegneroben != null)
            {
                labeloben.Text = gegneroben.Spielername;
                labeloben.Location = new Point((int)((this.Width - labeloben.Width) / 2), gegneroben.Location.Y + Karte.Hoehe + 15);
                labeloben.Anchor = AnchorStyles.Top;
            }
            
            if (gegnerrechts != null)
            {
                labelrechts.Text = gegnerrechts.Spielername;
                labelrechts.Location = new Point(gegnerrechts.Location.X - labelrechts.Width - 15, (int)((this.Height - labelrechts.Height) / 2));
                labelrechts.Anchor = AnchorStyles.Right;
            }
            
            if (gegnerlinks != null)
            {
                labellinks.Text = gegnerlinks.Spielername;
                labellinks.Location = new Point(gegnerlinks.Location.X + Karte.Hoehe + 15, (int)((this.Height - labellinks.Height) / 2));
                labellinks.Anchor = AnchorStyles.Left;
            }

            

            Refresh();
            #endregion
        }

        #endregion

        #region Andere Forms
        //Optionen
        private void optionenToolStripMenuItem_Click(object sender, EventArgs e)
        {
            optionen.ShowDialog();
        }

        //Regeln
        private void toolStripMenuItemHilfe_Click(object sender, EventArgs e)
        {
            MessageBox.Show(@"Zu Beginn erhält jeder Spieler 5 der insgesamt 32 Karten. 
Eine Karte wird offen in die Mitte gelegt, um den Ablagestapel zu eröffnen, der Rest der Karten dient als Ziehstapel.
Wer an der Reihe ist, kann entweder eine Karte passender Farbe oder passenden Wertes auf den Ablagestapel legen 
oder eine Karte vom verdeckten Stapel ziehen. Falls die gezogene Karte auf dem Stapel ablegbar ist, muss diese auch abgelegt werden.
Sobald eine Karte abgelegt wurde oder die gezogene Karte nicht ablegbar ist, ist der nächste Spieler an der Reihe.


Bei einigen Karten verändert sich dieser normale Spielablauf, wenn sie auf den Ablagestapel gelegt werden:

7: Der nächste Spieler muss 2 Karten vom verdeckten Stapel ziehen. Falls dieser ebenfalls eine 7 legt, muss der nun folgende Gegner 4 Karten ziehen usw.
8: Der nächste Spieler muss aussetzen.
9: Der Spieler darf sich eine Farbe wünschen (Herz, Gras, Eichel oder Schellen). Der nächste Spieler muss nun eine dazu passende Karte legen.
Ass: Der Spieler muss noch eine Karte legen bevor der nächste Spieler an der Reihe ist. Falls er das nicht kann, muss er eine Karte ziehen.


Die Anzahl der Gegner, sowie ihre Namen sind im Optionsmenü festlegbar. 
Außerdem lässt sich die Geschwindigkeit auswählen, mit der die Gegner ihre Züge durchführen.","Regeln");
        }

        //Infobox
        private void toolStripMenuItemAbout_Click(object sender, EventArgs e)
        {
            MessageBox.Show(@"Dies ist ein Programm von Patricia Vierling und Martin Buchner. 
Es wurde im Wintersemester 2011/2012 im Rahmen des C#-Kurses der 
Physik-Fakultät der Universität Regensburg als Abschlussprojekt erstellt.","Info");
        }
        #endregion
    }
}
