﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Audio;

namespace Pong
{
    /// <summary>
    /// EventItem, das einen zusätzlichen Ball erzeugt
    /// </summary>
    class BallVerdoppelItem : EventItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues BallVerdoppelItem mit dem Random random
        /// </summary>
        /// <param name="random"></param>
        public BallVerdoppelItem(Random random)
            : base("Ballverdopplung.png", random)
        {
            treffer = new Sound("Ballverdopplung.wav");
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Erzeugt einen neuen Ball, der in die entgegengesetzte y-Richtung fliegt
        /// </summary>
        /// <param name="seite"></param>
        public override void getroffen(Spieler.Seite seite, Ball ball)
        {
            foreach (PongItem pi in ball.Pongmaster.Items)
            {
                if (pi is Ball && !(pi as Ball).Aktiv)
                {
                    (pi as Ball).X = ball.X;
                    (pi as Ball).Y = ball.Y;
                    (pi as Ball).BallSpeedX = ball.BallSpeedX;
                    (pi as Ball).BallSpeedY = -ball.BallSpeedY;
                    (pi as Ball).Seit = ball.Seit;
                    (pi as Ball).Aktiv = true;
                    
                    break;
                }
            }

            // BallverdoppelItem tritt nur einmal auf
            Verwendet = false;

            base.getroffen(seite, ball);
        }

        #endregion
    }
}
