﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Audio;

namespace Pong
{
    /// <summary>
    /// EventItem, das den Ball nach oben beschleunigt bzw. abbremst
    /// </summary>
    class BoostObenItem : EventItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues BoostObenItem mit dem Random random
        /// </summary>
        /// <param name="random"></param>
        public BoostObenItem(Random random)
            : base("BoostOben.png", random)
        {
            
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Beschleunigt den Ball nach oben bzw. bremst den Ball ab
        /// </summary>
        /// <param name="seite"></param>
        public override void getroffen(Spieler.Seite seite, Ball ball)
        {
            if (ball.BallSpeedY > 0)
            {
                treffer = new Sound("Abbremsung.wav");
                ball.BallSpeedY /= 2;
            }
            else
            {
                treffer = new Sound("Beschleunigung.wav");
                ball.BallSpeedY *= 1.5;
            }

            base.getroffen(seite, ball);
        }

        #endregion
    }
}
