﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Core;

namespace Pong
{
    /// <summary>
    /// Das Hauptmenü der Anwendung, das zu allen anderen Untermenüs und dem Spiel weiterleitet
    /// </summary>
    class HauptMenu : Menu
    {
        #region Variablendeklarierung

        /// <summary>
        /// Delegate für einen Spielstart
        /// </summary>
        public delegate void SpielStarter();

        /// <summary>
        /// Event für den Spielstart
        /// </summary>
        public event SpielStarter spielstarter;

        /// <summary>
        /// Delegate für einen Beenden der Anwendung
        /// </summary>
        public delegate void Beender();

        /// <summary>
        /// Event für das Beenden der Anwendung
        /// </summary>
        public event Beender beender;

        /// <summary>
        /// Legt fest, ob das Optionenmenü gezeigt werden soll
        /// </summary>
        bool optionenzeigen;
        
        /// <summary>
        /// Die für den Spieler verfügbaren Optionen
        /// </summary>
        Option[] optionen;

        /// <summary>
        /// Optionenmenü für das Bearbeiten der Optionen
        /// </summary>
        HauptOptionenMenu optionenmenu;

        /// <summary>
        /// Alle im Spiel verwendeten EventItems
        /// </summary>
        EventItem[] eventitems;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues HauptMenu mit Namen Hauptmenü, den Optionen optionen für das OptionenMenu und den EventItems eventitems
        /// </summary>
        /// <param name="optionen"></param>
        /// <param name="eventitems"></param>
        public HauptMenu(Option[] optionen,EventItem[] eventitems)
            : base("Hauptmenü")
        {
            this.optionen = optionen;
            this.eventitems = eventitems;
            optionenzeigen = false;

            //Initialisierung des Optionenmenüs
            optionenmenu = new HauptOptionenMenu(optionen,eventitems);
            optionenmenu.akzeptiert += new OptionenMenu.Akzeptiert(weitermachen);
            
            // Anzahl der MenuItems festlegen
            items = new MenuItem[3];

            // MenuItems erstellen und in items ablegen, das erste MenuItem wird aktiv gesetzt
            items[0] = new MenuItem("Spiel starten", 10f);
            items[0].Aktiv = true;
            items[1] = new MenuItem("Optionen", 10f);
            items[2] = new MenuItem("Beenden", 10f);
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Führt die Funktion hinter dem aktuell aktiven MenuItem aus
        /// </summary>
        /// <param name="ai"></param>
        public override void aktivieren(int ai)
        {
            switch (ai) 
            {
                case 0 :
                    spielstarter();
                    break;
                case 1 :
                    optionenzeigen=true;
                    break;
                case 2 :
                    beender();
                    break;
            }
        }

        /// <summary>
        /// Wird bei jedem Drücken einer Taste aufgerufen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Keydown(object sender, SdlDotNet.Input.KeyboardEventArgs e)
        {
            if (optionenzeigen)
                optionenmenu.Events_Keydown(sender, e);
            else
                base.Events_Keydown(sender, e);
        }

        /// <summary>
        /// Wird bei jedem Frame aufgerufen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Tick(object sender, TickEventArgs e)
        {
            if (optionenzeigen)
                optionenmenu.Events_Tick(sender, e);
            else
                base.Events_Tick(sender, e);
        }

        /// <summary>
        /// Geht wieder zurück zum Hauptmenü
        /// </summary>
        private void weitermachen()
        {
            optionenzeigen = false;
        }

        #endregion
    }
}
