﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Audio;

namespace Pong
{
    /// <summary>
    /// EventItem, das dem treffenden Spieler einen Extrapunkt gewährt
    /// </summary>
    class PlusPunktItem : EventItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues PlusPunktItem mit dem Random random
        /// </summary>
        /// <param name="random"></param>
        public PlusPunktItem(Random random)
            : base("Pluspunkt.png",random)
        {
            treffer = new Sound("Itemtreffer.wav");
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Gibt dem Spieler der Seite seite einen Pluspunkt
        /// </summary>
        /// <param name="seite"></param>
        public override void getroffen(Spieler.Seite seite, Ball ball)
        {
            foreach (PongItem pi in Pongmaster.Items)
            {
                if (pi is Spieler && (pi as Spieler).Seit == seite)
                    (pi as Spieler).Punkte += 1;
            }

            base.getroffen(seite, ball);
        }

        #endregion
    }
}
