﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Graphics.Sprites;
using SdlDotNet.Graphics;
using System.Drawing;

namespace Pong
{   
    /// <summary>
    /// Allgemeine Oberklasse für alle im Spiel vorkommenden Objekte
    /// </summary>
    class PongItem : SDLItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Referenz auf die Masterklasse, um mit anderen PongItems interagieren zu können
        /// </summary>
        PongMaster pongmaster;

        #endregion

        #region Konstruktor


        /// <summary>
        /// Erstellt ein leeres PongItem (wird für den Punktestand benötigt)
        /// </summary>
        public PongItem()
        {
            
        }

        /// <summary>
        /// Erstellt ein PongItem, das als Sprite das Bild mit dem Dateinamen bildname verwendet
        /// </summary>
        /// <param name="bildname"></param>
        public PongItem(string bildname)
        {
            sprite = new Sprite(new Surface(bildname));
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt den Pongmaster fest, in dem das PongItem liegt oder gibt diesen zurück
        /// </summary>
        public PongMaster Pongmaster
        {
            get { return pongmaster; }
            set { pongmaster = value; }
        }

        #endregion
    }
}
