﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Pong
{
    /// <summary>
    /// Eine Option für Texte
    /// </summary>
    class TextOption : Option
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt den Text der TextOption fest
        /// </summary>
        string text;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt eine neue TextOption mit dem Namen name und dem Text text
        /// </summary>
        /// <param name="name"></param>
        /// <param name="text"></param>
        public TextOption(string name, string text)
        {
            Name = name;
            Bildname = null;
            this.text = text;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt den Text der TextOption oder gibt diesen zurück
        /// </summary>
        public override object Wert
        {
            get { return text; }
            set { text = value.ToString(); }
        }

        #endregion
    }
}
