﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Pong
{
    /// <summary>
    /// Option, bei der man aus verschiedenen Elementen, eine auswählen kann
    /// </summary>
    class AuswahlOption : Option
    {
        #region Variablendeklarierung

        /// <summary>
        /// Legt die momentane Auswahl fest
        /// </summary>
        int wert;

        /// <summary>
        /// Legt die auswählbaren Elemente fest
        /// </summary>
        string[] auswahl;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt eine neue AuswahlOption mit dem Namen name, den auswählbaren Elementen auswahl und dem momentan ausgewählten Element mit Index wert
        /// </summary>
        /// <param name="name"></param>
        /// <param name="auswahl"></param>
        /// <param name="wert"></param>
        public AuswahlOption(string name, string[] auswahl, int wert)
        {
            Name = name;
            Bildname = null;
            this.auswahl = auswahl;
            this.wert = wert;
        }

        /// <summary>
        /// Erstellt eine neue AuswahlOption mit dem Namen name, einem Bild mit Namen bildname, den auswählbaren Elementen auswahl und dem momentan ausgewählten Element mit Index wert
        /// </summary>
        /// <param name="name"></param>
        /// <param name="bildname"></param>
        /// <param name="auswahl"></param>
        /// <param name="wert"></param>
        public AuswahlOption(string name, string bildname, string[] auswahl, int wert)
        {
            Name = name;
            Bildname = bildname;
            this.auswahl = auswahl;
            this.wert = wert;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt das momentan ausgewählte Element der AuswahlOption auf das Element mit dem Index Wert oder gibt diesen zurück
        /// </summary>
        public override object Wert
        {
            get { return wert; }
            set { wert = (int)value; }
        }

        /// <summary>
        /// Setzt die auswählbaren Elemente der AuswahlOption oder gibt diese zurück
        /// </summary>
        public string[] Auswahl
        {
            get { return auswahl; }
            set { auswahl = value; }
        }

        #endregion
    }
}
