﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Audio;

namespace Pong
{
    /// <summary>
    /// EventItem, das den Ball nach unten beschleunigt bzw. abbremst
    /// </summary>
    class BoostUntenItem : EventItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues BoostUntenItem mit dem Random random
        /// </summary>
        /// <param name="random"></param>
        public BoostUntenItem(Random random)
            : base("BoostUnten.png", random)
        {
            
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Beschleunigt den Ball nach unten bzw. bremst den Ball ab
        /// </summary>
        /// <param name="seite"></param>
        public override void getroffen(Spieler.Seite seite, Ball ball)
        {
            if (ball.BallSpeedY < 0)
            {
                treffer = new Sound("Abbremsung.wav");
                ball.BallSpeedY /= 2;
            }
            else
            {
                treffer = new Sound("Beschleunigung.wav");
                ball.BallSpeedY *= 1.5;
            }

            base.getroffen(seite, ball);
        }

        #endregion
    }
}
