﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Core;
using SdlDotNet.Input;

namespace Pong
{
    /// <summary>
    /// Das Optionenmenü, das vom Hauptmenü aus erreichbar ist
    /// </summary>
    class HauptOptionenMenu : OptionenMenu
    {
        #region Variablendeklarierung

        /// <summary>
        /// Alle einstellbaren Optionen im HauptOptionenMenü
        /// </summary>
        Option[] optionen;
        
        /// <summary>
        /// Das EventOptionenMenu, das die Verwendung der einzelnen EventItems festlegt
        /// </summary>
        OptionenMenu eventoptionenmenu;

        /// <summary>
        /// Legt fest, ob das EventOptionenMenu gerade aktiv ist
        /// </summary>
        bool eventoptionaktiv;

        /// <summary>
        /// Alle im Spiel existierenden EventItems
        /// </summary>
        EventItem[] eventitems;

        /// <summary>
        /// Die zu den eventitems gehörenden Optionen
        /// </summary>
        Option[] eventoptionen;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues HauptOptionenMenu mit den Optionen optionen und den EventItems eventitems
        /// </summary>
        /// <param name="optionen"></param>
        /// <param name="eventitems"></param>
        public HauptOptionenMenu(Option[] optionen, EventItem[] eventitems)
            : base(optionen, "Optionen", 1)
        {
            this.optionen = optionen;
            this.eventitems = eventitems;

            items[items.Length - 2] = new MenuItem("Verwendete Items", 10f);

            // Optionen für das eventoptionenmenu aus den eventitems erstellen
            eventoptionen = new Option[eventitems.Length];

            for (int i = 0; i < eventoptionen.Length; i++)
            {
                eventoptionen[i] = new AuswahlOption(eventitems[i].Name, eventitems[i].Name+".png", Enum.GetNames(typeof(Pong.JaNein)), (int)Pong.JaNein.Ja);
            }

            eventoptionenmenu = new OptionenMenu(eventoptionen, "Welche Items sollen verwendet werden?", 0);
            eventoptionenmenu.akzeptiert += new Akzeptiert(weitermachen);
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Löst die Funktion hinter dem MenuItem mit dem Index ai aus
        /// </summary>
        /// <param name="ai"></param>
        public override void aktivieren(int ai)
        {
            if (ai == items.Length - 2)
            {
                eventoptionaktiv = true;
            }
            else
                base.aktivieren(ai);
        }

        /// <summary>
        /// Aktiviert das HauptOptionenmenü vom eventoptionmenu aus und legt die Verwendbarkeit für alle eventitems nach den eingestellten Optionen fest
        /// </summary>
        public void weitermachen()
        {
            for (int i = 0; i < eventitems.Length; i++)
            {
                switch ((Pong.JaNein)eventoptionen[i].Wert)
                {
                    case Pong.JaNein.Ja :
                        eventitems[i].Verwendet = true;
                        break;
                    case Pong.JaNein.Nein:
                        eventitems[i].Verwendet = false;
                        break;
                }
            }
            eventoptionaktiv = false;
        }

        /// <summary>
        /// Wird beim Zeichnen jedes Frames aufgerufen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Tick(object sender, TickEventArgs e)
        {
            if (eventoptionaktiv)
                eventoptionenmenu.Events_Tick(sender, e);
            else
                base.Events_Tick(sender, e);
        }

        /// <summary>
        /// Wird beim Drücken einer Taste aufgerufen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Keydown(object sender, KeyboardEventArgs e)
        {
            if (eventoptionaktiv)
                eventoptionenmenu.Events_Keydown(sender, e);
            else
                base.Events_Keydown(sender, e);
        }

        #endregion
    }
}
