﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Audio;

namespace Pong
{
    /// <summary>
    /// EventItem, das dem treffenden Spieler einen Punkt abzieht
    /// </summary>
    class MinusPunktItem : EventItem
    {
        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues MinusPunktItem mit dem Random random
        /// </summary>
        /// <param name="random"></param>
        public MinusPunktItem(Random random)
            : base("Minuspunkt.png", random)
        {
            treffer = new Sound("Itemtreffer.wav");
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Zieht dem Spieler der Seite seite Punkt ab
        /// </summary>
        /// <param name="seite"></param>
        public override void getroffen(Spieler.Seite seite, Ball ball)
        {
            foreach (PongItem pi in Pongmaster.Items)
            {
                if (pi is Spieler && (pi as Spieler).Seit == seite)
                    (pi as Spieler).Punkte -= 1;
            }

            base.getroffen(seite, ball);
        }

        #endregion
    }
}
