﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Input;

namespace Pong
{
    /// <summary>
    /// Allgemeine Oberklasse für alle in der Anwendung vorkommenden Optionenmenüs
    /// </summary>
    class OptionenMenu : Menu
    {
        #region Variablendeklarierung

        /// <summary>
        /// Delegate für das Akzeptieren der Optionen
        /// </summary>
        public delegate void Akzeptiert();

        /// <summary>
        /// Event für das Akzeptieren der Optionen
        /// </summary>
        public event Akzeptiert akzeptiert;

        /// <summary>
        /// Alle angezeigten Optionen
        /// </summary>
        Option[] optionen;

        /// <summary>
        /// Legt fest, ob gerade eine Option geändert wird
        /// </summary>
        bool optionaktiv;

        /// <summary>
        /// Legt fest, welche Option gerade aktiv ist
        /// </summary>
        int aktiveoption;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt ein neues Optionenmenü mit dem Namen name und einer zusätzlichen Anzahl von zusatz an freien Plätzen für MenuItems 
        /// </summary>
        /// <param name="optionen"></param>
        /// <param name="name"></param>
        /// <param name="zusatz"></param>
        public OptionenMenu(Option[] optionen, string name, int zusatz)
            : base(name)
        {
            this.optionen = optionen;

            items = new MenuItem[optionen.Length+zusatz+1];

            for(int i=0;i<optionen.Length;i++)
            {
                if (optionen[i] is TextOption)
                    items[i] = new TextInputItem(optionen[i] as TextOption, 10f);
                else if (optionen[i] is IntOption)
                    items[i] = new IntInputItem(optionen[i] as IntOption, 10f);
                else if (optionen[i] is AuswahlOption)
                    items[i] = new AuswahlInputItem(optionen[i] as AuswahlOption, 10f);
            }

            items[items.Length-1] = new MenuItem("OK", 10f);
            items[0].Aktiv = true;
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Löst die Funktion hinter dem MenuItem mit dem Index ai aus
        /// </summary>
        /// <param name="ai"></param>
        public override void aktivieren(int ai)
        {
            if (ai == items.Length-1)
                akzeptiert();
            else
            {
                optionaktiv = true;
                aktiveoption = ai;
            }
        }
        
        /// <summary>
        /// Wird bei jedem Drücken einer Taste aufgerufen
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public override void Events_Keydown(object sender, KeyboardEventArgs e)
        {
            if (optionaktiv)
            {
                if (e.Key == Key.Return)
                    optionaktiv = false;
                else
                    (items[aktiveoption] as InputItem).Events_Keydown(sender, e);
            }
            else
                base.Events_Keydown(sender, e);
        }

        #endregion
    }
}
