﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using SdlDotNet.Input;

namespace Pong
{
    //------------------------------------------------------------------------------------------
    //Funktioniert überhaupt noned!!!!!
    //------------------------------------------------------------------------------------------

    /// <summary>
    /// Die TextBox, die die Verarbeitung von Texteingaben übernimmt
    /// </summary>
    class PongTextBox : TextBox
    {
        /// <summary>
        /// Erstellt eine neue PongTextBox mit dem Text text und der maximalen Zeichenzahl maxlength
        /// </summary>
        /// <param name="text"></param>
        /// <param name="maxlength"></param>
        public PongTextBox(string text, int maxlength)
        {
            Text = text;
            MaxLength = maxlength;
        }

        /// <summary>
        /// Übermittelt die KeyboardEventArgs an die TextBox
        /// </summary>
        /// <param name="e"></param>
        public void sendKeys(KeyboardEventArgs e)
        {
            KeyEventArgs keyeventargs = KeyEventArgs.Empty as KeyEventArgs;

            switch (e.Key)
            {
                case Key.A :
                    keyeventargs = new KeyEventArgs(Keys.A);
                    break;
                case Key.B:
                    keyeventargs = new KeyEventArgs(Keys.B);
                    break;
                case Key.C:
                    keyeventargs = new KeyEventArgs(Keys.C);
                    break;
                
            }
            
            base.OnKeyDown(keyeventargs);
        }
    }
}
