﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Graphics.Sprites;
using SdlDotNet.Graphics;

namespace Pong
{
    /// <summary>
    /// Allgemeine Oberklasse für alle in der Anwendung vorkommenden Objekte
    /// </summary>
    class SDLItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Sprite für das jeweilige Objekt
        /// </summary>
        protected Sprite sprite;

        /// <summary>
        /// x-Position des Sprites als double, um ein besseres Geschwindigkeitsverhalten zu gewährleisten
        /// </summary>
        double x;

        /// <summary>
        /// y-Position des Sprites als double, um ein besseres Geschwindigkeitsverhalten zu gewährleisten
        /// </summary>
        double y;

        #endregion

        #region Konstruktor


        /// <summary>
        /// Erstellt ein leeres SDLItem
        /// </summary>
        public SDLItem()
        {
           
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt die x-Position des Sprites des SDLItems oder gibt sie zurück
        /// </summary>
        public double X
        {
            get { return x; }
            set { x = value; }
        }

        /// <summary>
        /// Setzt die y-Position des Sprites des SDLItems oder gibt sie zurück
        /// </summary>
        public double Y
        {
            get { return y; }
            set { y = value; }
        }

        /// <summary>
        /// Gibt die Höhe des Sprites des SDLItems zurück
        /// </summary>
        public int Height
        {
            get { return sprite.Height; }
        }

        /// <summary>
        /// Gibt die Breite des Sprites des SDLItems zurück
        /// </summary>
        public int Width
        {
            get { return sprite.Width; }
        }

        #endregion

        # region Methoden

        /// <summary>
        /// Zeichnet den Sprite des SDLItems
        /// </summary>
        public virtual void draw()
        {
            if (sprite == null)
                return;

            // Legt die Positon des Sprites fest und zeichnet dieses
            sprite.X = (int)X;
            sprite.Y = (int)Y;
            Video.Screen.Blit(sprite);
        }

        #endregion
    }
}
