﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SdlDotNet.Graphics;

namespace Pong
{
    /// <summary>
    /// Stellt das Paddle eines Spielers dar
    /// </summary>
    class Spieler : PongItem
    {
        #region Variablendeklarierung

        /// <summary>
        /// Geschwindigkeit des Paddles
        /// </summary>
        double paddleSpeed;

        /// <summary>
        /// Punktestand des Spielers
        /// </summary>
        int punkte;

        /// <summary>
        /// Seite des Spielers
        /// </summary>
        Seite seit;

        /// <summary>
        /// Legt fest, ob nach oben gefahren werden soll
        /// </summary>
        bool rauf;

        /// <summary>
        /// Legt fest, ob nach unten gefahren werden soll
        /// </summary>
        bool runter;

        #endregion

        #region Konstruktor

        /// <summary>
        /// Erstellt einen neuen Spieler auf der Seite seite
        /// </summary>
        /// <param name="seite"></param>
        public Spieler(Seite seite)
            : base("Paddle"+(int)seite+".png")
        {
            this.seit = seite;
            
            // Standardgeschwindigkeit des Paddles
            paddleSpeed = 3.0;

            // Startpunktestand des Spielers
            Punkte = 0;

            //Startwerte festlegen
            rauf = false;
            runter = false;
        }

        #endregion

        #region Variablenzugriff

        /// <summary>
        /// Setzt den Punktestand des Spielers fest oder gibt ihn zurück
        /// </summary>
        public int Punkte
        {
            get { return punkte; }
            set { punkte = value; }
        }

        /// <summary>
        /// Gibt die Seite des Spielers zurück
        /// </summary>
        public Seite Seit
        {
            get { return seit; }
        }

        /// <summary>
        /// Setzt, ob das Paddle nach oben fahren soll oder nicht, oder gibt dies zurück
        /// </summary>
        public bool Rauf
        {
            get { return rauf; }
            set { rauf = value; }
        }

        /// <summary>
        /// Setzt, ob das Paddle nach unten fahren soll oder nicht, oder gibt dies zurück
        /// </summary>
        public bool Runter
        {
            get { return runter; }
            set { runter = value; }
        }

        #endregion

        #region Methoden

        /// <summary>
        /// Überschreiben der draw-Methode, um auf das Verhalten der Paddle einzugehen
        /// </summary>
        public override void draw()
        {
            // Überprüfen, ob das Paddle nach oben fahren soll
            if (Rauf)
            {
                Y -= paddleSpeed;

                // Nicht höher als das Fenster fahren
                if (Y < 0)
                {
                    Y = 0;
                }
            }

            // Überprüfen, ob das Paddle nach unten fahren soll
            if (Runter)
            {
                Y += paddleSpeed;

                // Nicht tiefer als das Fenster Fahren
                if ((Y + Height) > Video.Screen.Height)
                {
                    Y = Video.Screen.Height - Height;
                }
            }


            base.draw();
        }

        #endregion

        #region Enumeration Seite

        /// <summary>
        /// Enumeration für die Spielerseiten
        /// </summary>
        public enum Seite : int
        {
            /// <summary>
            /// Der linke Spieler
            /// </summary>
            Links = 1,

            /// <summary>
            /// Der rechte Spieler
            /// </summary>
            Rechts = 2,
        }

        #endregion
    }
}
