﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CSharpProjekt {
    public class KartenGenerator {

        /// <summary>
        /// Generiert eine zufällige Karte
        /// </summary>
        /// <param name="rand">die übergebene Random-Instanz</param>
        /// <returns>die generierte Karte</returns>
        public Karte KarteGenerieren(Random rand) {
            int idx = rand.Next(21);
            switch (idx) {
                case 0:
                    return new Baumeister();
                case 1:
                    return new Bewässerung();
                case 2:
                    return new Erdbeben();
                case 3:
                    return new Frontalangriff();
                case 4:
                    return new Füllhorn();
                case 5:
                    return new Handlungsfreiheit();
                case 6:
                    return new Kinderarbeit();
                case 7:
                    return new Medizin();
                case 8:
                    return new Miliz();
                case 9:
                    return new Pest();
                case 10:
                    return new Schützenstand();
                case 11:
                    return new Schwertleite();
                case 12:
                    return new Steuererhöhung();
                case 13:
                    return new Tunnelgräber();
                case 14:
                    return new Wehrpflicht();
                case 15:
                    return new Dürre();
                case 16:
                    return new Rekrut();
                case 17:
                    return new Meuchelmörder();
                case 18:
                    return new Handwerk();
                case 19:
                    return new Fortschritt();
                case 20:
                    return new Katapulte();

                default:
                    throw new Exception("Falsche Zufallszahl!");
            }
        }
    }
}
