﻿using System;
using System.Collections.Generic;
using System.Text;

namespace CSharpProjekt {
    public class WertAenderung : IAttribut{
        protected int aenderung; //Die Höhe in der der Wert geändert werden soll
        protected bool betrifftAusspieler; //ob ein Wert des Spielers oder seines Gegners geändert wird
        SpielerVariablen zuÄndernderWert;

        public WertAenderung(int aenderung, bool eigenesAttribut, SpielerVariablen var) {
            this.aenderung = aenderung;
            this.betrifftAusspieler = eigenesAttribut;
            zuÄndernderWert = var;
        }

        public void Ausführen(Spieler spieler) {
            switch (zuÄndernderWert) {
                case SpielerVariablen.leben:
                    if (betrifftAusspieler) {
                        spieler.Lebenspunkte += aenderung;
                    } else {
                        spieler.Gegner.Lebenspunkte += aenderung;
                    }
                    break;
                case SpielerVariablen.mauer:
                    if (betrifftAusspieler) {
                        spieler.Mauer += aenderung;
                        if (spieler.Mauer < 0)
                            spieler.Mauer = 0;
                    } else {
                        spieler.Gegner.Mauer += aenderung;
                        if (spieler.Gegner.Mauer < 0)
                            spieler.Gegner.Mauer = 0;
                    }
                    break;
                case SpielerVariablen.nahrung:
                    if (betrifftAusspieler) {
                        spieler.Rohstoffe[(int)RohstoffListe.nahrung] += aenderung;
                        if (spieler.Rohstoffe[(int)RohstoffListe.nahrung] < 0)
                            spieler.Rohstoffe[(int)RohstoffListe.nahrung] = 0;
                    } else {
                        spieler.Gegner.Rohstoffe[(int)RohstoffListe.nahrung] += aenderung;
                        if (spieler.Gegner.Rohstoffe[(int)RohstoffListe.nahrung] < 0)
                            spieler.Gegner.Rohstoffe[(int)RohstoffListe.nahrung] = 0;
                    }
                    break;
                case SpielerVariablen.gold:
                    if (betrifftAusspieler) {
                        spieler.Rohstoffe[(int)RohstoffListe.gold] += aenderung;
                        if (spieler.Rohstoffe[(int)RohstoffListe.gold] < 0)
                            spieler.Rohstoffe[(int)RohstoffListe.gold] = 0;
                    } else {
                        spieler.Gegner.Rohstoffe[(int)RohstoffListe.gold] += aenderung;
                        if (spieler.Gegner.Rohstoffe[(int)RohstoffListe.gold] < 0)
                            spieler.Gegner.Rohstoffe[(int)RohstoffListe.gold] = 0;
                    }
                    break;
                case SpielerVariablen.stein:
                    if (betrifftAusspieler) {
                        spieler.Rohstoffe[(int)RohstoffListe.steine] += aenderung;
                        if (spieler.Rohstoffe[(int)RohstoffListe.steine] < 0)
                            spieler.Rohstoffe[(int)RohstoffListe.steine] = 0;
                    } else {
                        spieler.Gegner.Rohstoffe[(int)RohstoffListe.steine] += aenderung;
                        if (spieler.Gegner.Rohstoffe[(int)RohstoffListe.steine] < 0)
                            spieler.Gegner.Rohstoffe[(int)RohstoffListe.steine] = 0;
                    }
                    break;
                case SpielerVariablen.feld:
                    if (betrifftAusspieler) {
                        spieler.Prod[(int)Produktion.feld] += aenderung;
                        if (spieler.Prod[(int)Produktion.feld] < 0)
                            spieler.Prod[(int)Produktion.feld] = 0;
                    } else {
                        spieler.Gegner.Prod[(int)Produktion.feld] += aenderung;
                        if (spieler.Gegner.Prod[(int)Produktion.feld] < 0)
                            spieler.Gegner.Prod[(int)Produktion.feld] = 0;
                    }
                    break;
                case SpielerVariablen.mine:
                    if (betrifftAusspieler) {
                        spieler.Prod[(int)Produktion.mine] += aenderung;
                        if (spieler.Prod[(int)Produktion.mine] < 0)
                            spieler.Prod[(int)Produktion.mine] = 0;
                    } else {
                        spieler.Gegner.Prod[(int)Produktion.mine] += aenderung;
                        if (spieler.Gegner.Prod[(int)Produktion.mine] < 0)
                            spieler.Gegner.Prod[(int)Produktion.mine] = 0;
                    }
                    break;
                case SpielerVariablen.steinbruch:
                    if (betrifftAusspieler) {
                        spieler.Prod[(int)Produktion.steinbruch] += aenderung;
                        if (spieler.Prod[(int)Produktion.steinbruch] < 0)
                            spieler.Prod[(int)Produktion.steinbruch] = 0;
                    } else {
                        spieler.Gegner.Prod[(int)Produktion.steinbruch] += aenderung;
                        if (spieler.Gegner.Prod[(int)Produktion.steinbruch] < 0)
                            spieler.Gegner.Prod[(int)Produktion.steinbruch] = 0;
                    }
                    break;
                case SpielerVariablen.schwert:
                    if (betrifftAusspieler) {
                        spieler.Armee.EinheitenZahlAendern(Truppen.schwert, aenderung);
                    } else {
                        spieler.Gegner.Armee.EinheitenZahlAendern(Truppen.schwert, aenderung);
                    }
                    break;
                case SpielerVariablen.bogen:
                    if (betrifftAusspieler) {
                        spieler.Armee.EinheitenZahlAendern(Truppen.bogen, aenderung);
                    } else {
                        spieler.Gegner.Armee.EinheitenZahlAendern(Truppen.bogen, aenderung);
                    }
                    break;
                case SpielerVariablen.ritter:
                    if (betrifftAusspieler) {
                        spieler.Armee.EinheitenZahlAendern(Truppen.ritter, aenderung);
                    } else {
                        spieler.Gegner.Armee.EinheitenZahlAendern(Truppen.ritter, aenderung);
                    }
                    break;
                default:
                    break;
            }

            
        }

        public override string ToString() {
            switch (zuÄndernderWert) {
                case SpielerVariablen.leben:
                    if (betrifftAusspieler)
                        return "Lebenspunkte " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Lebenspunkte " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.mauer:
                    if (betrifftAusspieler)
                        return "Stadtmauer " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Stadtmauer " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.nahrung:
                    if (betrifftAusspieler)
                        return "Nahrung " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Nahrung " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.gold:
                    if (betrifftAusspieler)
                        return "Gold " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerisches Gold " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.stein:
                    if (betrifftAusspieler)
                        return "Stein " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Steine " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.feld:
                    if (betrifftAusspieler)
                        return "Felder " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Felder " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.mine:
                    if (betrifftAusspieler)
                        return "Goldminen " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Goldminen " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.steinbruch:
                    if (betrifftAusspieler)
                        return "Steinbrüche " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Steinbrüche " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.schwert:
                    if (betrifftAusspieler)
                        return "Schwertkämpfer " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Schwertkämpfer " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.bogen:
                    if (betrifftAusspieler)
                        return "Bogenschützen " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Bogenschützen " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                case SpielerVariablen.ritter:
                    if (betrifftAusspieler)
                        return "Ritter " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                    return "Gegnerische Ritter " + (aenderung >= 0 ? "+" + aenderung : "-" + (-aenderung));
                default:
                    return String.Empty;
            }
        }
    }

    public enum SpielerVariablen {
        leben,
        mauer,
        nahrung,
        gold,
        stein,
        feld,
        mine,
        steinbruch,
        schwert,
        bogen,
        ritter,
    }
}