﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace CSharpProjekt {
    public class Spiel {
        
        //diverse globale Konstanten die das gesamte Spiel charakterisieren
        public const int StartKartenAnzahl = 6;
        public const int MaxKartenAnzahl = 7;
        public const int LebenStartwert = 10;
        public const int MauerStartwert = 10;
        public const int ProduktionStartwert = 3;
        public const int SchwertStartwert = 1;
        public const int BogenStartwert = 1;
        public const int RitterStartwert = 0;
        public const int RohstoffeStartwert = 4;
        public const int RohstoffAnzahl = 3;
        public const int TruppenArtAnzahl = 3;
       
        
        Spieler spieler1; //der untere Spieler
        Spieler spieler2; //der oberere Spieler
        String spielerName1;
        String spielerName2;
        Form hauptfenster;

        public Spiel (Form form, String spielerName1, String spielerName2) {
            hauptfenster = form;
            this.spielerName1 = spielerName1;
            this.spielerName2 = spielerName2;
            initialisieren ();
            RundeStarten (spieler1, true);
            spieler2.Control.setSpielerControlsEnabled(false); //workaround damit die rundeBeendenButtons von Spieler 2 am Anfang disabled sind
            
        }

        public void initialisieren () {
            spieler1 = new Spieler (spielerName1);
            spieler2 = new Spieler(spielerName2);


            
            spieler1.Control = (hauptfenster as Form1).SpielerControl1;
            spieler2.Control = (hauptfenster as Form1).SpielerControl2;
            (hauptfenster as Form1).SpielerControl1.Spieler = spieler1;
            (hauptfenster as Form1).SpielerControl2.Spieler = spieler2;

            HandkartenInitialisieren(spieler1);
            HandkartenInitialisieren(spieler2);

            spieler1.Control.spielerNamenLabel.Text = spielerName1;
            spieler2.Control.spielerNamenLabel.Text = spielerName2;

            spieler1.Gegner = spieler2;
            spieler2.Gegner = spieler1;
            spieler1.Control.LabelsAktualisieren();
            spieler2.Control.LabelsAktualisieren();
        }

        public void HandkartenInitialisieren (Spieler spieler) {
            spieler.Handkarten = new List<Karte> (7);
            spieler.Control.KarteControlsLeeren();

            // Random-Instanz wird hier nur einmal erzeugt und als Parameter übergeben, anstatt inherhalb der KarteZiehen-Methode jeweils eine eigene Instanz zu erzeugen
            // weil sonst mehrere Instanzen zur gleichen Systemzeit erzeugt werden (also den gleichen Seed haben) und somit viele gleiche Karten herauskommen 
            Random rand = new Random();
            for (int i = 0; i < StartKartenAnzahl; i++) {
                spieler.KarteZiehen (rand);
            }
        }

        public void RundeStarten (Spieler spieler, bool ersteRunde) {
            spieler.Aktionen = 1;
            if (!ersteRunde) // Der Startspieler bekommt in der ersten Runde keine Zusatzrohstoffe um den Startvorteil auszugleichen
                spieler.RohstoffvorratVerändern(spieler.Prod[(int)Produktion.feld], spieler.Prod[(int)Produktion.mine], spieler.Prod[(int)Produktion.steinbruch]);
            spieler.Armee.Regenerieren();
            spieler.Control.LabelsAktualisieren();
            spieler.Control.setSpielerControlsEnabled(true);
            spieler.Control.NichtSpielbareKartenControlsDisablen();
        }

        public void RundeBeenden (Spieler spieler) {
            //überprüfen ob das Spiel zu Ende ist
            Spieler sieger;
            if ((sieger = SiegerPrüfen(spieler1)) != null) {
                MessageBox.Show(sieger.ToString() + " hat das Spiel gewonnen!");
                spieler1.Control.setSpielerControlsEnabled(false);
                spieler2.Control.setSpielerControlsEnabled(false);
                return;
            }
            Random rand = new Random();
            //Am Ende der Runde wird die Handkartenanzahl wieder aufgestockt
            while (spieler.Handkarten.Count < Spiel.StartKartenAnzahl)
                spieler.KarteZiehen(rand);
            
            spieler.Control.setSpielerControlsEnabled(false);
            RundeStarten(spieler.Gegner, false);
        }

        /// <summary>
        /// Prüft ob einer der Spieler schon gewonnen hat
        /// </summary>
        /// <param name="spieler"></param>
        /// <returns>Den Sieger des Spiels oder null wenn das Spiel nicht vorbei ist</returns>
        public Spieler SiegerPrüfen(Spieler spieler) {
            if (spieler.Lebenspunkte <= 0)
                return spieler.Gegner;
            if (spieler.Gegner.Lebenspunkte <= 0)
                return spieler;
            if (spieler.Gegner.Rohstoffe[(int)RohstoffListe.nahrung] >= 50 && spieler.Gegner.Rohstoffe[(int)RohstoffListe.gold] >= 50 && spieler.Gegner.Rohstoffe[(int)RohstoffListe.steine] >= 50)
                return spieler.Gegner;
            if (spieler.Rohstoffe[(int)RohstoffListe.nahrung] >= 50 && spieler.Rohstoffe[(int)RohstoffListe.gold] >= 50 && spieler.Rohstoffe[(int)RohstoffListe.steine] >= 50)
                return spieler;
            return null;
        }
    }
}
