﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace CSharpProjekt {
    public partial class SpielerControl : UserControl {
        Spieler spieler;
        ControlCollection kartenControls;
        Dictionary<KarteControl, AbwerfenButton> zuordnung; //ordnet jedem KarteControl den passenden AbwerfenButton zu

        public Dictionary<KarteControl, AbwerfenButton> Zuordnung {
            get { return zuordnung; }
        }

        public Spieler Spieler {
            get { return spieler; }
            set { spieler = value; }
        }
        public ControlCollection KartenControls {
            get { return kartenControls; }
        }

        public Spiel Spiel {
            get { return (Parent as Form1).Spiel; }
        }

        public SpielerControl() {
            InitializeComponent();
            kartenControls = handkartenbereich.Controls;
            zuordnung = new Dictionary<KarteControl, AbwerfenButton>(7);
            zuordnung.Add(karte1, abwerfenButton1);
            zuordnung.Add(karte2, abwerfenButton2);
            zuordnung.Add(karte3, abwerfenButton3);
            zuordnung.Add(karte4, abwerfenButton4);
            zuordnung.Add(karte5, abwerfenButton5);
            zuordnung.Add(karte6, abwerfenButton6);
            zuordnung.Add(karte7, abwerfenButton7);

            foreach (KarteControl karte in zuordnung.Keys)
                abwurfButtonInitialisieren(zuordnung[karte], karte);

            foreach (KarteControl karte in kartenControls) {
                karte.KarteAusgespielt += new EventHandler(karte_KarteAusgespielt);
            }

            lebenPictureBox.Image = PicLib.Properties.Pics.heart;
            mauerPictureBox.Image = PicLib.Properties.Pics.wall;
            nahrungPictureBox.Image = PicLib.Properties.Pics.getreide;
            goldPictureBox.Image = PicLib.Properties.Pics.gold;
            steinPictureBox.Image = PicLib.Properties.Pics.bricks;
            feldPictureBox.Image = PicLib.Properties.Pics.feld;
            minePictureBox.Image = PicLib.Properties.Pics.gold_mine;
            steinbruchPictureBox.Image = PicLib.Properties.Pics.quarry;
            schwertPictureBox.Image = PicLib.Properties.Pics.schwert;
            bogenPictureBox.Image = PicLib.Properties.Pics.bow;
            ritterPictureBox.Image = PicLib.Properties.Pics.knight;
        }

        void karte_KarteAusgespielt(object sender, EventArgs e) {
            if ((sender as KarteControl).Karte == null)
                return;

            (sender as KarteControl).Karte.Ausführen(Spieler);
            (sender as KarteControl).setVisibility(false);
            if ((sender as KarteControl).Karte is AktionsKarte)
                Spieler.Aktionen--;
            Spieler.Handkarten.Remove((sender as KarteControl).Karte);
            zuordnung[(sender as KarteControl)].Enabled = false;
            (sender as KarteControl).Karte = null;

            LabelsAktualisieren();
            spieler.Gegner.Control.LabelsAktualisieren();
            NichtSpielbareKartenControlsDisablen();
            //(sender as KarteControl).KarteAusgespielt -= new EventHandler(karte_KarteAusgespielt);
            //if (Spieler.Aktionen <= 0)
            //    Spiel.RundeBeenden(Spieler);
        }

        void karte_Abgeworfen(object sender, EventArgs e) {
            if (Spieler == null || Spieler.Handkarten == null || sender == null || (sender as AbwerfenButton).KarteCont == null)
                return;
            Spieler.Handkarten.Remove((sender as AbwerfenButton).KarteCont.Karte);
            (sender as AbwerfenButton).Enabled = false;
            Spiel.RundeBeenden(Spieler);
        }

        /// <summary>
        /// Alle KarteControls, AbwerfenButtons und den Button zum Beenden der Runde enablen (zu Beginn des Zugs des jeweiligen Spielers)
        /// oder disablen (am Ende des Zugs)
        /// </summary>
        /// <param name="enabled"></param>
        public void setSpielerControlsEnabled(bool enabled) {
            foreach (KarteControl contr in kartenControls) {
                contr.Enabled = enabled;
                if (contr.Karte != null)
                    zuordnung[contr].Enabled = enabled;
            }
            rundeBeendenButton.Enabled = enabled;
        }

        /// <summary>
        /// Wenn der Spieler nicht genug Rohstoffe oder Aktionen hat um die Karte auszuspielen soll sie disablet werden
        /// </summary>
        public void NichtSpielbareKartenControlsDisablen() {
            foreach (KarteControl contr in kartenControls) {
                if (contr.Karte != null && contr.Karte.prüfeObAusreichendRohstoffeVorhanden(Spieler) && (!(contr.Karte is AktionsKarte) || Spieler.Aktionen >= 1))
                    contr.Enabled = true;
                else
                    contr.Enabled = false;
            }
        }

        public void setKarteControlsVisible(bool visible) {
            foreach (KarteControl contr in kartenControls)
                contr.setVisibility(visible);
            this.Refresh();
        }

        public void KarteControlsLeeren() {
            for (int i = kartenControls.Count - 1; i >= 0; i--) {
                (kartenControls[i] as KarteControl).KarteEntfernen();
            }
        }

        public void LabelsAktualisieren() {
            lebenLabel.Text = "LE:" + Spieler.Lebenspunkte;
            mauerLabel.Text = "MA:" + Spieler.Mauer;

            nahrungLabel.Text = "NA:" + Spieler.Rohstoffe[(int)RohstoffListe.nahrung];
            goldLabel.Text = "GO:" + Spieler.Rohstoffe[(int)RohstoffListe.gold];
            steinLabel.Text = "ST:" + Spieler.Rohstoffe[(int)RohstoffListe.steine];

            feldLabel.Text = "FE:" + Spieler.Prod[(int)Produktion.feld];
            mineLabel.Text = "MI:" + Spieler.Prod[(int)Produktion.mine];
            steinbruchLabel.Text = "SB:" + Spieler.Prod[(int)Produktion.steinbruch];

            schwertLabel.Text = "SW:" + Spieler.Armee.EinheitenAnzahl(Truppen.schwert);
            bogenLabel.Text = "BG:" + Spieler.Armee.EinheitenAnzahl(Truppen.bogen);
            ritterLabel.Text = "RI:" + Spieler.Armee.EinheitenAnzahl(Truppen.ritter);
        }

        private void rundeBeendenButton_Click(object sender, EventArgs e) {
            Spiel.RundeBeenden(Spieler);
        }

        private void abwurfButtonInitialisieren(AbwerfenButton button, KarteControl karte) {
            button.KarteCont = karte;
            button.KarteAbgeworfen += new EventHandler(karte_Abgeworfen);
            button.Visible = true;
        }

        private void pictureBox8_Click(object sender, EventArgs e) {

        }

    }
}
