﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

///
/// WRITTEN BY FLORIAN RAPPL, 2011
/// CODE IS FREE TO USE -- CPOL [ Code Project Open License ]
/// 

namespace rsi.Controls.iToolTip
{
    public partial class LightBulb : Control
    {
        #region members

        Bitmap lightbulb;

        #endregion

        #region ctor

        /// <summary>
        /// Constructs a new lightbulb control element
        /// </summary>
        public LightBulb()
        {
            lightbulb = Resources.lightbulb;
            SetStyle(ControlStyles.SupportsTransparentBackColor, true);
            BackColor = Color.Transparent;
        }

        #endregion

        #region overrides

        protected override void OnPaint(PaintEventArgs e)
        {
            //Draws the lightbulb
            e.Graphics.DrawImageUnscaled(lightbulb, 0, 0);
        }

        protected override void OnSizeChanged(EventArgs e)
        {
            //Checks the lightbulb's element size
            if (!Size.Equals(lightbulb.Size))
                Size = lightbulb.Size;
        }

        #endregion

        #region properties

        /// <summary>
        /// Gets or sets the icon that is displayed in the control.
        /// </summary>
        [Description("Changes the image to display.")]
        public Bitmap Lightbulb
        {
            get { return lightbulb; }
            set { lightbulb = value; OnSizeChanged(EventArgs.Empty); }
        }

        #endregion
    }
}
