﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

///
/// WRITTEN BY FLORIAN RAPPL, 2011
/// CODE IS FREE TO USE -- CPOL [ Code Project Open License ]
/// 

namespace rsi.Controls.iToolTip
{
    public class MeasureToolTipEventArgs : EventArgs
    {
        #region members

        object toolTip;
        int height;
        int width;
        Font font;

        #endregion

        #region ctor

        /// <summary>
        /// Creates a new instance of a MeasureToolTip event argument
        /// </summary>
        /// <param name="font">The font that will be used</param>
        /// <param name="toolTip">The toolTip that should be drawn</param>
        /// <param name="height">The height that is default</param>
        /// <param name="width">The width that is default</param>
        public MeasureToolTipEventArgs(Font font, object toolTip, int height, int width)
        {
            this.font = font;
            this.toolTip = toolTip;
            this.height = height;
            this.width = width;
        }

        #endregion

        #region properties

        /// <summary>
        /// Gets the font that will be used for drawing.
        /// </summary>
        public Font Font { get { return font; } }

        /// <summary>
        /// Gets the object that should be drawn.
        /// </summary>
        public object ToolTip { get { return toolTip; } }

        /// <summary>
        /// Gets or sets the height of the tooltip.
        /// </summary>
        public int Height { get { return height; } set { height = value; } }

        /// <summary>
        /// Gets or sets the width of the tooltip.
        /// </summary>
        public int Width { get { return width; } set { width = value; } }

        #endregion
    }
}
