﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

///
/// WRITTEN BY FLORIAN RAPPL, 2011
/// CODE IS FREE TO USE -- CPOL [ Code Project Open License ]
/// 

namespace rsi.Controls.iToolTip
{
    public class ToolTipDataEventArgs : EventArgs
    {
        #region members

        object result;
        Exception exception;
        Control control;

        #endregion

        #region ctors

        public ToolTipDataEventArgs() : this(string.Empty, null, null)
        { }

        public ToolTipDataEventArgs(object result) : this(result, null, null)
        { }

        public ToolTipDataEventArgs(object result, Control control) : this(result, control, null)
        { }

        public ToolTipDataEventArgs(object result, Control control, Exception exception)
        {
            this.result = result;
            this.control = control;
            this.exception = exception;
        }

        #endregion

        #region properties

        /// <summary>
        /// Gets the control associated with the ToolTip request.
        /// </summary>
        public Control Control
        {
            get { return control; }
        }

        /// <summary>
        /// Gets the result associated with the ToolTip request.
        /// </summary>
        public object Result
        {
            get { return result; }
        }

        /// <summary>
        /// Indicates if the request was successfully executed.
        /// </summary>
        public bool Success
        {
            get { return exception == null; }
        }

        /// <summary>
        /// Gets the exception that has been thrown by the request.
        /// </summary>
        public Exception Exception
        {
            get { return exception; }
        }

        #endregion
    }
}
