﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace Beispiel
{
    class Spirale : Control
    {
        Timer timer;
        int frame = 0;
        const int MAXFRAME = 20;

        public int Frame
        {
            get { return frame; }
            private set 
            {
                if (value < MAXFRAME)
                    frame = value;
                else
                    frame = 0;

                Refresh(); 
            }
        }

        public Spirale()
        {
            timer = new Timer();
            timer.Interval = 200;
            timer.Tick += new EventHandler(timerTick);

            DoubleBuffered = true;

            SetStyle(ControlStyles.OptimizedDoubleBuffer | ControlStyles.UserPaint, true);
        }

        void timerTick(object sender, EventArgs e)
        {
            Frame++;
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            Rectangle rect = new Rectangle(-20, -20, 40, 40);
            LinearGradientBrush lgb = new LinearGradientBrush(rect, Color.Red, Color.Orange, LinearGradientMode.ForwardDiagonal);
            g.SmoothingMode = SmoothingMode.AntiAlias;
            g.FillRectangle(Brushes.White, e.ClipRectangle);
            float dx = (float)Width / MAXFRAME;
            g.TranslateTransform(dx * Frame, Height / 2);
            float dalpha = 20f + (float)(10.0 * Math.Sin(Math.PI * (double)frame / (double)MAXFRAME));
            g.RotateTransform(dalpha);
            g.ScaleTransform(2f, 2f);
            int dmund = 25 - (int)(25.0 * Math.Cos(2 * Math.PI * (double)frame / (double)MAXFRAME));
            g.FillPie(lgb, -20, -20, 40, 40, -dmund/2, 310 + dmund);
            g.FillEllipse(Brushes.Yellow, 1, -17, 5, 5);
            base.OnPaint(e);
        }

        public void Start()
        {
            timer.Start();
        }

        public void Stop()
        {
            timer.Stop();
        }

        protected override void OnResize(EventArgs e)
        {
            Invalidate();
            base.OnResize(e);
        }
    }
}
