﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

namespace Beispiel
{
    public partial class Processes : Form
    {
        public Processes()
        {
            InitializeComponent();
        }

        private void Processes_Load(object sender, EventArgs e)
        {
            listBox1.Items.Clear();
            Process[] p = Process.GetProcesses();
            listBox1.Items.AddRange(p);
        }

        private void listBox1_DrawItem(object sender, DrawItemEventArgs e)
        {
            if (e.Index < 0 || e.Index >= listBox1.Items.Count)
                return;

            StringFormat sf = new StringFormat();
            sf.Alignment = StringAlignment.Near;
            sf.LineAlignment = StringAlignment.Center;
            Process p = listBox1.Items[e.Index] as Process;
            e.DrawBackground();
            Graphics g = e.Graphics;
            Rectangle r = new Rectangle(e.Bounds.X, e.Bounds.Y, e.Bounds.Width, e.Bounds.Height);
            g.DrawImage(ImageResources.proc, e.Bounds.X + 1, e.Bounds.Y + 1, 48, 48);
            r.X = 52;
            r.Width -= 52;
            g.DrawString(p.ProcessName, new Font(e.Font, FontStyle.Bold), new SolidBrush(e.ForeColor), r, sf);
            sf.Alignment = StringAlignment.Far;
            g.DrawString(p.Threads.Count + " Threads", e.Font, new SolidBrush(e.ForeColor), r, sf);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Process p = listBox1.SelectedItem as Process;
            p.Kill();
            listBox1.Items.Remove(p);
        }
    }
}
