﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Globalization;

namespace Beispiel
{
    public partial class Form1 : LanguageForm
    {
        const string DE = "de-de";
        const string ZW = "en-ZW";

        static string currentLanguage = DE;

        public Form1()
        {
            InitializeComponent();
            SetLanguage();
        }

        public override void SetLanguage()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(Form1));
            resources.ApplyResources(this.button1, "button1");
            resources.ApplyResources(this, "$this");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            
            if(currentLanguage == DE)
                currentLanguage = ZW;
            else
                currentLanguage = DE;

            CultureInfo lang = new CultureInfo(currentLanguage);
            Thread.CurrentThread.CurrentCulture = lang;
            Thread.CurrentThread.CurrentUICulture = lang;

            foreach (LanguageForm form in Application.OpenForms)
                form.SetLanguage();

            MessageBox.Show(MessageBoxTexts.LanguageSwitch);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            new Form1().Show();
        }
    }
}
