function addFile(name) {
    var container = $('#content');
    var file = $('<a>').addClass('file').attr('href', settings.fileDirURL + name).text(name);
    var imgSrc = settings.baseURL + 'icons/files/';
    var temp = name.split('.');
    var extension = temp[temp.length - 1];
    switch(extension) {
        case 'pdf':
            imgSrc += 'PortableDocumentFormat.png';
            break;
        case 'mp3':
        case 'wav':
            imgSrc += 'AudioFile.png';
            break;
        case 'mov':
        case 'mkv':
        case 'flv':
            imgSrc += 'GenericMovieClip.png';
            break;
        case 'png':
        case 'bmp':
        case 'svg':
            imgSrc += 'Image_File.png';
            break;
        case 'exe':
            imgSrc += 'Generic_Application.png';
            break;
        case 'exe':
            imgSrc += 'zippedFile.png';
            break;
        default:
            imgSrc += 'Generic_Document.png';
            break;
    }
    $('<img>').attr('src', imgSrc).prependTo(file);
    file.appendTo(container);
}

//load publicly available files
function loadFileBrowser(callback) {
    $('#content').html('');
    addFile('RNA.pdf');
    addFile('thesis.pdf');
    addFile('masterarbeit.pdf');
    addFile('imperial march.mp3');
    addFile('Also sprach Zarathustra.mp3');
    addFile('Metallic Mario.mp3');
    addFile('FlagOfEurope.svg');
    addFile('Shohat - Ophir - Fly_Video_QT.flv');
    addFile('Projekt final.exe');
    addFile('spiel.exe');
    addFile('Aufgabe13.exe');

    if (callback != undefined)
        callback();
}