//load rss news ticker
function loadNewsTicker(feedURL, callback) {
    var newsContainer = $('#newsContainer').text('');
    $('<h3>').text('breaking news').prepend($('<img>').attr('src', settings.baseURL + 'icons/settings/base_rss.png')).appendTo(newsContainer);
    var news = $('<span>').appendTo(newsContainer);
    //weil ajax ja cross site nix zulässt
    var feed = new google.feeds.Feed(feedURL);
    feed.load(function (result) {
        if (!result.error) {
            for (var i = 0; i < result.feed.entries.length; i++) {
                var entry = result.feed.entries[i];
                var d = new Date(entry.publishedDate);
                news.append($('<a>').attr('href', entry.link)
                    .append($('<h4>').text(entry.title))).css('display', 'none')
                    .append($('<span>').text(entry.content.split('<')[0])).css('display', 'none')
                    .append($('<time>').text(d.toLocaleTimeString()).css('display', 'none')
                    );
            }
            function initializeNews() {
                var visibleNewsID = 0;
                var animateNews = function () {
                    news.fadeOut(settings.animationSpeed, function () {
                        news.children().each(function (i, v) {
                            if (i >= visibleNewsID * 3 && i < (visibleNewsID + 1) * 3)
                                $(v).css('display', 'inline');
                            else
                                $(v).css('display', 'none');
                        });
                        visibleNewsID++;
                        if (visibleNewsID >= news[0].children.length / 3)
                            visibleNewsID = 0;
                        news.fadeIn(settings.animationSpeed, function () { setTimeout(animateNews, 5000); });
                    });
                };
                animateNews();
            }
            initializeNews();
        }
        if (callback != undefined)
            callback();
    });
}

