;(function($, undefined) {
	var months_abbr = ['Jan', 'Feb', 'Mrz', 'Apr', 'Mai', 'Jun', 'Jul', 'Aug', 'Sep', 'Okt', 'Nov', 'Dez'];
	var months = ['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'];
	var days_abbr = ['Mo','Di','Mi','Do','Fr','Sa','So'];
	var belegung = new Array();	
	var notiz = new Array();
	var notizText = new Array();
	var defaults = { };
	$.fn.cal = function(options) {
		var options = $.extend(defaults, options);

		return this.each(function () {
			var cal = $(this);
			// Objekt das aktuelle Daten beinhaltet
			var current = new function() {
				var daylayerhead; // Tag für die Rückgabe im Head der Einzeltagesansicht
				var c = new Date();
				// Das Jahr zwischen 0 und 9999
				this.year = c.getFullYear();
				// Monat zwischen 1 und 12
				this.month = c.getMonth() + 1;
				// Tag zwischen 1 und 31
				this.day = c.getDate();
				// Aktuelle Ansicht 
				this.layer = 0;
				// Monatsindex zurückgeben
				this.monthIndex = function() {
					return this.month - 1;
				};
				//Dekade zurückgeben
				this.decade = function(idx) {
					var dc = parseInt(this.year / 10) * 10;
					return dc + idx + 1;
				};
				//Text für Navigationsleiste zurückgeben
				this.text = function() {
					if(this.layer === -1)
						return this.daylayerhead + ' ' + months[this.monthIndex()] + ' ' + this.year;
					else if(this.layer === 2)
						return this.decade(-1);
					else if(this.layer === 1)
						return this.year;
					else if(this.layer === 0)
						return months[this.monthIndex()] + ' ' + this.year;
				};
				//Offset für 1. des aktuellen Monats ermitteln (0 = Mo, 6 = So)
				this.offset = function() {
					return (new Date(this.year, this.monthIndex(), 1).getDay() + 6) % 7;
				};
				//Berechnet die Anzahl der Tage im jeweiligen Monat
				this.daysInMonth = function(monthShift) {
					var yr = this.year;
					var mt = this.monthIndex();
					if(monthShift) {
						mt += monthShift;

						if(mt < 0) {
							yr--;
							mt = 11;
						} else if(mt > 11) {
							yr++;
							mt = 0;
						}
					}
					return 32 - (new Date(yr, mt, 32).getDate());
				};				
				// Berechnet den vorherigen Monat
				this.previous = function() {
					if(this.layer === -1)
					{
						this.daylayerhead--;
						if(!this.daylayerhead) 
						{
							this.month--;
							this.daylayerhead = current.daysInMonth();
						}
						if(!this.month)
						{
							this.month = 12;
							this.year--;
						}
					}
					else if(this.layer === 2)
						this.year -= 10;
					else if(this.layer === 1)
						this.year--;
					else if (this.layer === 0) {
						this.month--;
						if(!this.month) {
							this.month = 12;
							this.year--;
						}
					}
				};				
				// Berechnet den nächsten Monat
				this.next = function() {
					if(this.layer === -1) 
					{
						this.daylayerhead++;
						if(this.daylayerhead > current.daysInMonth()) 
						{
							this.daylayerhead = 1;
							this.month++;
						}	
						if(this.month > 12) 
						{
							this.month = 1;
							this.year++;
						}						
					}
					else if(this.layer === 2)
						this.year += 10;
					else if(this.layer === 1)
						this.year++;
					else if (this.layer === 0) {
						this.month++;
						if(this.month > 12) {
							this.month = 1;
							this.year++;
						}
					}
				};
			};		
			
			// Funktion zum Initialisieren des Kalenders
			var init = function() {
				var top = $('<div />')
					.attr('id', 'cal-top')
					.appendTo(cal);
				var main = $('<div />')
					.attr('id', 'cal-main')
					.appendTo(cal);
				// Hilfsfunktion um Navigations-Buttons einzufügen
				var addNavigation = function(name, callback) {
					$('<div />')
						.addClass('cal-nav')
						.click(callback)
						.html(name)
						.appendTo(top);
				};
				// Linke Navigation anfügen
				addNavigation('&lt;&lt;', function() {
					current.previous();
					updateTime();					
				});
				// Mittlere Box anfügen
				$('<div />')
					.attr('id', 'cal-nav-top')
					.appendTo(top)
					.click(function() {
						setLayer(current.layer + 1);
						updateTime();
					});
				// Rechte Navigation anfügen
				addNavigation('&gt;&gt;', function() {
					current.next();
					updateTime();
				});
				// Die Ansicht für die Tage hinzufügen
				var layer_days = $('<div />')
					.addClass('cal-layer')
					.attr('id', 'cal-layer-days')
					.appendTo(main);
				// Füllen hier nur mit Konstrukt (keine Werte!)
				for(var i = 8; --i; ) {
					var row = $('<div />')
						.addClass('cal-day-row')
						.appendTo(layer_days);
					for(var j = 8; --j; )
					{
						$('<div />')
							.addClass('cal-day-cell')
							.appendTo(row);						
					}
				}
				// Wochentage (Spalten) festlegen
				$('.cal-day-cell')
					.filter(':lt(7)')
					.each(function(i, v) {
						$(this)
							.addClass('cal-day-rowhead')
							.text(days_abbr[i]);
					});
				// Ansicht für die Monate hinzufügen
				var layer_months = $('<div />')
					.addClass('cal-layer')
					.attr('id', 'cal-layer-months')
					.appendTo(main);
				// Monatsansicht befüllen
				for(var i = 0; i < 3; i++) {
					var row = $('<div />')
						.addClass('cal-month-row')
						.appendTo(layer_months);
					for(var j = 0; j < 4; j++)
						$('<div />')
							.addClass('cal-month-cell')
							.text(months_abbr[i * 4 + j])
							.appendTo(row);
				}
				// Callback für Monate festlegen
				$('.cal-month-cell').each(function(i, v) {
					$(this).click(function() {
						current.month = i + 1;
						setLayer(0);
						updateTime();
					});
				});
				// Ansicht für die Jahre hinzufügen
				var layer_years = $('<div />')
					.addClass('cal-layer')
					.attr('id', 'cal-layer-years')
					.appendTo(main);
				// Jahresansicht befüllen
				for(var i = 0; i < 3; i++) {
					var row = $('<div />')
						.addClass('cal-year-row')
						.appendTo(layer_years);
					for(var j = 0; j < 3; j++)
						$('<div />')
							.addClass('cal-year-cell')
							.appendTo(row);
				}
				// Callback für Jahre festlegen
				$('.cal-year-cell').each(function(i, v) {
					$(this).click(function() {
						current.year = parseInt($(this).text());
						setLayer(1);
						updateTime();
					});
				});
				// Einzeltagesansicht hinzufügen
				var layer_day = $('<div />')
					.addClass('cal-layer')
					.attr('id', 'cal-layer-day')
					.appendTo(main)
					.addClass('belegung')
					.html("<br/><br/><textarea class='notiztext' placeholder='Bitte geben Sie hier Ihre Notiz ein.' maxlength='504'></textarea><br/><button id='buttonNotizEinf' type='button'>Notiz hinzuf&uuml;gen</button><button id='buttonNotizEntf' type='button'>Notiz entfernen</button>");
								
				// Notiz hinzufügen
				var zaehl = notiz.length;
				
				$('#buttonNotizEinf').click(function() {						
					notiz[zaehl] = current.daylayerhead + '.' + current.month + '.' + current.year;
					notizText[zaehl] = $('.notiztext').val();
					zaehl++;
					
					setLayer(0);
					updateTime();
				});	
				
				// Notiz löschen
				$('#buttonNotizEntf').click(function() {						
					var index = jQuery.inArray($('.notiztext').val(), notizText);					
					notiz.splice(index, 1);					
					notizText.splice(index, 1);
					
					setLayer(0);
					updateTime();
				});	
						
				// bei Doppelklick auf Tag, Wechsel in die Einzeltagesansicht				
				$('.cal-day-cell').each(function(i, v) {
					$(this).dblclick(function() {	
						if(i-7-current.offset()+1 >= 1 && i-7-current.offset()+1 <= current.daysInMonth())
						{
							// falls eine Notiz vorhanden ist, Notiztext in textarea einfügen, um etwaige Änderungen zu ermöglichen							
							if(typeof($(this).attr('title')) != 'undefined')
								$('.notiztext').val($(this).attr('title'));
							else
								$('.notiztext').val('');
						
							current.daylayerhead = i-7-current.offset()+1;
							setLayer(-1);
							updateTime();
						}
					});	
				});
				
				
				// Markierung der Tage als belegt
				var anfang;	
				var zaehler = belegung.length;
								
				$('.cal-day-cell').each(function(i, v) {					
					$(this).mousedown(function() {	
						if(i-7-current.offset()+1 >= 1 && i-7-current.offset()+1 <= current.daysInMonth())
							anfang = i;							
					}).mouseup(function() {	
						if(i-7-current.offset()+1 >= 1 && i-7-current.offset()+1 <= current.daysInMonth())
						{
							var ende = i;							
							// Markierung vom Tag an dem die Maus gedrückt wurde, bis zum Tag, an dem die Maus losgelassen wurde
							if(anfang > ende)	// Austausch, falls vom letzten Tag ausgehend markiert wird
							{
								var temp = anfang;
								anfang = ende;
								ende = temp;
							}
							
							for(var z=anfang; z<=ende; z++)	
							{		
								// falls Datum bereits in Array vorhanden (Tag wurde ein zweites Mal ausgewählt)...
								var inBelegung = jQuery.inArray((z-7-current.offset()+1) + '.' + current.month + '.' + current.year, belegung);
								var inNotiz = jQuery.inArray((z-7-current.offset()+1) + '.' + current.month + '.' + current.year, notiz);
							
								if(inBelegung == -1)	// falls KEIN Eintrag in Belegung
								{
									belegung[zaehler] = (z-7-current.offset()+1) + '.' + current.month + '.' + current.year;
									zaehler++;	
									
									if(inNotiz == -1)	// falls KEIN Eintrag in Notiz
									{
										$('.cal-day-cell').eq(z).addClass('belegung');
									}
									else	
									{
										$('.cal-day-cell').eq(z).addClass('notiz-und-belegung');
									}
								}
								else
								{
									belegung.splice(inBelegung, 1);	// ...betreffendes Datum aus Array löschen
									$('.cal-day-cell').eq(z).removeClass('belegung');
																		
									if(inNotiz != -1)	// falls NICHT in Belegung, aber IN Notiz
									{
										$('.cal-day-cell').eq(z).removeClass('notiz-und-belegung').addClass('notiz');
									}
								}		
							}
						}	
					});	
										
				});	
			};
			//Funktion zum Anzeigen eines bestimmten Layers (Ansicht)
			var setLayer = function(index) {
				if(index > 2) {
					current.layer = 1;
					current.year = current.decade(-1);
				} else
					current.layer = index;
				$('.cal-layer')
					.fadeOut('slow')
					.eq(current.layer)
					.fadeIn('slow');
			};
			// Funktion um aktuelles Datum zu setzen
			var updateTime = function() {
				var prevDays = current.daysInMonth(-1);
				var days = current.daysInMonth();
				var offset = current.offset();
				var start = prevDays - offset + 1;
				
				var cNew = new Date();
				curYear = cNew.getFullYear();
				curMonth = cNew.getMonth() + 1;
				curDay = cNew.getDate();
				// etwaige hinzugefügte Stylinginformationen präventiv löschen, um sie später, falls zutreffend wieder hinzuzufügen
				$('#cal-layer-day').removeClass('belegung');
				$('.cal-day-cell').removeClass('belegung').removeClass('notiz').removeClass('notiz-und-belegung').removeAttr('title');				
				
				$('#cal-nav-top')
					.text(current.text());
				$('.cal-day-cell:gt(6)')
					.each(function(i, v) {
						var txt = i - offset + 1;
						var cls = 'cal-day-inactive';
						var cur = 'cal-day-cell-current';
																		
						if(i < offset)
							txt = start + i;
						else if(i >= offset + days)
							txt = i - offset - days + 1;
						else 
							cls = '';
							
						// aktuellen Tag farblich markieren
						if((i-offset+1) == curDay && current.month == curMonth && current.year == curYear)
							$(this).addClass(cur);
						else
							$(this).removeClass(cur);
												
						// Belegung farblich markieren
						for(var a=0; a<belegung.length; a++)
						{
							if(i-offset + '.' + current.month + '.' + current.year == belegung[a])
							{
								if(jQuery.inArray(i-offset + '.' + current.month + '.' + current.year, notiz) == -1)	
									$('.cal-day-cell').eq(i+6).addClass('belegung');
								else
									$('.cal-day-cell').eq(i+6).addClass('notiz-und-belegung');
							}
						}
						
						// Notizen farblich markieren und title-Attribut setzen
						for(var a=0; a<notiz.length; a++)
						{
							if(i-offset + '.' + current.month + '.' + current.year == notiz[a])
							{
								var notizUndBelegung = jQuery.inArray(i-offset + '.' + current.month + '.' + current.year, belegung);	
								
								if(notizUndBelegung == -1)
									$('.cal-day-cell').eq(i+6).addClass('notiz').attr('title', notizText[a]);
								else
									$('.cal-day-cell').eq(i+6).addClass('notiz-und-belegung').attr('title', notizText[a]);
							}
						}
												
						$(this)
							.text(txt)
							.removeClass('cal-day-inactive')
							.addClass(cls);
					}); 
				$('.cal-year-cell')
					.each(function(i, v) {
						$(this).text(current.decade(i));
					});
			};
			cal.empty();
			init();
			setLayer(0);
			updateTime();
		});
	};
})(jQuery);