﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Malefiz
{
    public partial class Hauptfenster : Form
    {
        Figur GewählteFigur;
        bool WurdeFigurAusgewählt;
        bool ZieheMitNeuerFigur;
        bool KamSchonFigurAusHaus;
        Spielbrett brett;
        static int x_länge = 17;
        static int y_länge = 14;
        static int feldgröße = 28;
        static int feldabstand_x = 6;
        static int feldabstand_y = 7;
        static int AnzahlDerSpieler = 4;

        PictureBox[][] Spielfelder = new PictureBox[x_länge][];
        PictureBox[][] Hausfelder = new PictureBox[AnzahlDerSpieler][];
        
        
        public Hauptfenster()
        {            
            //Startet das Spiel und initialisiert das brett.
            InitializeComponent();
            WurdeFigurAusgewählt = false;
            Spielbrett.BackgroundImage = Malefiz.pictures.Spielbrett;
            Startfenster sf = new Startfenster();
            sf.ShowDialog();
            Spielerauswahl sa = new Spielerauswahl();
            sa.ShowDialog();
            brett = new Spielbrett(sa.SpielerEins, sa.SpielerZwei, sa.SpielerDrei, sa.SpielerVier);

            //Schreibt Anfangswerte von brett in die dafür vorgesehenen Labels des Hauptfensters.
            this.Icon = pictures.Pistole;
            aktueller_spielername.Text = brett.spielerpool[brett.WerIstDran].Spielername;
            Spieler_pic.BackgroundImage = brett.spielerpool[brett.WerIstDran].Spielerporträt;

            //Erstellt die Picture-Boxen, auf denen die Spielfiguren wandern können.
            for (int x = 0; x < x_länge; x++)
            {
                Spielfelder[x] = new PictureBox[y_länge];

                for (int y = 0; y < y_länge; y++)
                {
                    PictureBox feld = new PictureBox();
                    Spielfelder[x][y] = feld;
                    Spielbrett.Controls.Add(feld);
                    if (y == 13)
                    {
                        feld.Bounds = new Rectangle(13 + (x * (feldgröße + feldabstand_x)), 447 - (y * (feldgröße + feldabstand_x)), feldgröße, feldgröße);
                    }
                    else
                    {
                        feld.Bounds = new Rectangle(13 + (x * (feldgröße + feldabstand_x)), 455 - (y * (feldgröße + feldabstand_x)), feldgröße, feldgröße);
                    }

                    feld.BackColor = System.Drawing.Color.Transparent;

                    //feld.Tag = brett;
                    feld.BackgroundImage = brett.felderpool[x][y].Feldbild;
                    feld.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
                    Spielfelder[x][y].Tag = new Feldposition(x, y);
                    feld.MouseClick += new MouseEventHandler(feld_MouseClick);
                }
            }

            //Erstellt die Picture-Boxen, die die Hausfelder darstellen.
            for (int spielernummer = 0; spielernummer < AnzahlDerSpieler; spielernummer++)
            {
                Hausfelder[spielernummer] = new PictureBox[5];

                PictureBox haus0 = new PictureBox();
                PictureBox haus1 = new PictureBox();
                PictureBox haus2 = new PictureBox();
                PictureBox haus3 = new PictureBox();
                PictureBox haus4 = new PictureBox();

                Spielbrett.Controls.Add(haus0);
                Spielbrett.Controls.Add(haus1);
                Spielbrett.Controls.Add(haus2);
                Spielbrett.Controls.Add(haus3);
                Spielbrett.Controls.Add(haus4);

                haus0.BackColor = System.Drawing.Color.Transparent;
                haus1.BackColor = System.Drawing.Color.Transparent;
                haus2.BackColor = System.Drawing.Color.Transparent;
                haus3.BackColor = System.Drawing.Color.Transparent;
                haus4.BackColor = System.Drawing.Color.Transparent;

                if (spielernummer == 0)     //Rotes Haus
                {
                    haus0.Bounds = new Rectangle(41, 519, feldgröße, feldgröße);
                    haus1.Bounds = new Rectangle(83, 489, feldgröße, feldgröße);
                    haus2.Bounds = new Rectangle(124, 520, feldgröße, feldgröße);
                    haus3.Bounds = new Rectangle(106, 568, feldgröße, feldgröße);
                    haus4.Bounds = new Rectangle(57, 567, feldgröße, feldgröße);
                }

                if (spielernummer == 1)     //Grünes Haus
                {
                    haus0.Bounds = new Rectangle(177, 518, feldgröße, feldgröße);
                    haus1.Bounds = new Rectangle(218, 488, feldgröße, feldgröße);
                    haus2.Bounds = new Rectangle(259, 518, feldgröße, feldgröße);
                    haus3.Bounds = new Rectangle(244, 567, feldgröße, feldgröße);
                    haus4.Bounds = new Rectangle(192, 566, feldgröße, feldgröße);
                }

                if (spielernummer == 2)     //Gelbes Haus
                {
                    haus0.Bounds = new Rectangle(313, 517, feldgröße, feldgröße);
                    haus1.Bounds = new Rectangle(355, 487, feldgröße, feldgröße);
                    haus2.Bounds = new Rectangle(396, 517, feldgröße, feldgröße);
                    haus3.Bounds = new Rectangle(380, 566, feldgröße, feldgröße);
                    haus4.Bounds = new Rectangle(329, 566, feldgröße, feldgröße);
                }

                if (spielernummer == 3)     //Blaues Haus
                {
                    haus0.Bounds = new Rectangle(449, 518, feldgröße, feldgröße);
                    haus1.Bounds = new Rectangle(490, 488, feldgröße, feldgröße);
                    haus2.Bounds = new Rectangle(531, 518, feldgröße, feldgröße);
                    haus3.Bounds = new Rectangle(515, 566, feldgröße, feldgröße);
                    haus4.Bounds = new Rectangle(465, 566, feldgröße, feldgröße);
                }

                //Das funktioniert: feld.BackgroundImage = brett.felderpool[x][y].Feldbild;
                haus0.BackgroundImage = brett.häuserpool[spielernummer][0].Figurenporträt;
                haus1.BackgroundImage = brett.häuserpool[spielernummer][1].Figurenporträt;
                haus2.BackgroundImage = brett.häuserpool[spielernummer][2].Figurenporträt;
                haus3.BackgroundImage = brett.häuserpool[spielernummer][3].Figurenporträt;
                haus4.BackgroundImage = brett.häuserpool[spielernummer][4].Figurenporträt;


                haus0.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
                haus1.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
                haus2.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
                haus3.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;
                haus4.BackgroundImageLayout = System.Windows.Forms.ImageLayout.Stretch;

                Hausfelder[spielernummer][0] = haus0;
                Hausfelder[spielernummer][1] = haus1;
                Hausfelder[spielernummer][2] = haus2;
                Hausfelder[spielernummer][3] = haus3;
                Hausfelder[spielernummer][4] = haus4;

                for (int figurennummer = 0; figurennummer < 5; figurennummer++)
                {
                    Hausfelder[spielernummer][figurennummer].Tag = new Figurennummerierung(spielernummer, figurennummer);
                    Hausfelder[spielernummer][figurennummer].MouseDoubleClick += new MouseEventHandler(Hauptfenster_MouseDoubleClick);
                }
            }
        }

        void feld_MouseClick(object sender, MouseEventArgs e)
        {
            PictureBox picbox = (PictureBox)sender;
            Feldposition position = (Feldposition)picbox.Tag;
            Nachrichtenlabel.Text = "Ungültige Eingabe";

            //Der Spieler hat keine Züge mehr
            if (brett.NochZuGehen == 0)
            { return; }

            //Aufnehmen einer Barrikade
            if (WurdeFigurAusgewählt == true && ((GewählteFigur.X + 1 == position.X && GewählteFigur.Y == position.Y) || (GewählteFigur.X - 1 == position.X && GewählteFigur.Y == position.Y)
                || (GewählteFigur.Y + 1 == position.Y && GewählteFigur.X == position.X) || (GewählteFigur.Y - 1 == position.Y && GewählteFigur.X == position.X)) && brett.felderpool[position.X][position.Y].IstBlockiert == true)
            {
                if (brett.felderpool[position.X][position.Y].IstBlockiert == true && WurdeFigurAusgewählt == true)
                {
                    if (brett.NochZuGehen == 1)
                    {
                        brett.NehmeBarrikade(brett.figurenpool[brett.WerIstDran][GewählteFigur.Figurennummer], brett.barrikadenpool[brett.felderpool[position.X][position.Y].Barrikadennummer]);
                    }
                    else
                    {
                        //Dieser Zug wird nicht möglich sein!
                        brett.Move(brett.figurenpool[brett.WerIstDran][GewählteFigur.Figurennummer], brett.felderpool[position.X][position.Y]);
                        WurdeFigurAusgewählt = false;
                        GewählteFigur = null;
                        brett.MussteZugZurücksetzen = false;

                        for (int x = 0; x < x_länge; x++)
                        {
                            for (int y = 0; y < y_länge; y++)
                            {
                                if (brett.felderpool[x][y].ExistiertDasFeld == false)       //Totes Feld
                                {
                                    continue;
                                }
                                Spielfelder[x][y].BackgroundImage = brett.felderpool[x][y].Feldbild;
                            }
                        }
                        for (int spielernummer = 0; spielernummer < AnzahlDerSpieler; spielernummer++)
                        {
                            Hausfelder[spielernummer][0].BackgroundImage = brett.häuserpool[spielernummer][0].Figurenporträt;
                            Hausfelder[spielernummer][1].BackgroundImage = brett.häuserpool[spielernummer][1].Figurenporträt;
                            Hausfelder[spielernummer][2].BackgroundImage = brett.häuserpool[spielernummer][2].Figurenporträt;
                            Hausfelder[spielernummer][3].BackgroundImage = brett.häuserpool[spielernummer][3].Figurenporträt;
                            Hausfelder[spielernummer][4].BackgroundImage = brett.häuserpool[spielernummer][4].Figurenporträt;
                        }

                        noch_zu_ziehen.Text = ("Du musst noch " + brett.NochZuGehen + " Züge gehen.");
                        Nachrichtenlabel.Text = "";
                        return;
                    }

                    Spielfelder[position.X][position.Y].BackgroundImage = brett.felderpool[position.X][position.Y].Feldbild;
                    Spielfelder[GewählteFigur.X][GewählteFigur.Y].BackgroundImage = brett.felderpool[GewählteFigur.X][GewählteFigur.Y].Feldbild;

                    if (brett.MussteZugZurücksetzen == true)
                    {
                        brett.MussteZugZurücksetzen = false;
                        for (int x = 0; x < x_länge; x++)
                        {
                            for (int y = 0; y < y_länge; y++)
                            {
                                if (brett.felderpool[x][y].ExistiertDasFeld == false)       //Totes Feld
                                {
                                    continue;
                                }
                                Spielfelder[x][y].BackgroundImage = brett.felderpool[x][y].Feldbild;
                            }
                        }
                        for (int spielernummer = 0; spielernummer < AnzahlDerSpieler; spielernummer++)
                        {
                            Hausfelder[spielernummer][0].BackgroundImage = brett.häuserpool[spielernummer][0].Figurenporträt;
                            Hausfelder[spielernummer][1].BackgroundImage = brett.häuserpool[spielernummer][1].Figurenporträt;
                            Hausfelder[spielernummer][2].BackgroundImage = brett.häuserpool[spielernummer][2].Figurenporträt;
                            Hausfelder[spielernummer][3].BackgroundImage = brett.häuserpool[spielernummer][3].Figurenporträt;
                            Hausfelder[spielernummer][4].BackgroundImage = brett.häuserpool[spielernummer][4].Figurenporträt;
                        }
                    }
                }
                Nachrichtenlabel.Text = "Barrikade wurde aufgenommen";
                return;
            }

            //Spieler möchte Barrikade in die untersten zwei Reihen setzen! Das ist nicht möglich.
            if (brett.spielerpool[brett.WerIstDran].HatBarrikade == true && (position.Y == 0 || position.Y == 1))
            {
                MessageBox.Show("Die Barrikade darf nicht auf die untersten zwei Reihen versetzt werden!", "Versetzen nicht möglich");
                Nachrichtenlabel.Text = "";
                return;
            }

            if (brett.spielerpool[brett.WerIstDran].HatBarrikade == true && (brett.felderpool[position.X][position.Y].IstBelegt == true || brett.felderpool[position.X][position.Y].IstBlockiert == true))
            {
                return;
            }

            //Versetzen einer Barrikade
            if (brett.spielerpool[brett.WerIstDran].HatBarrikade == true && position.Y != 0 && position.Y != 1)
            {
                brett.VersetzeBarrikade(brett.barrikadenpool[brett.spielerpool[brett.WerIstDran].Barrikadennummer], brett.felderpool[position.X][position.Y]);

                for (int x = 0; x < x_länge; x++)
                {
                    for (int y = 0; y < y_länge; y++)
                    {
                        if (brett.felderpool[x][y].ExistiertDasFeld == false)       //Totes Feld
                        {
                            continue;
                        }
                        Spielfelder[x][y].BackgroundImage = brett.felderpool[x][y].Feldbild;
                    }
                }
                for (int spielernummer = 0; spielernummer < AnzahlDerSpieler; spielernummer++)
                {
                    Hausfelder[spielernummer][0].BackgroundImage = brett.häuserpool[spielernummer][0].Figurenporträt;
                    Hausfelder[spielernummer][1].BackgroundImage = brett.häuserpool[spielernummer][1].Figurenporträt;
                    Hausfelder[spielernummer][2].BackgroundImage = brett.häuserpool[spielernummer][2].Figurenporträt;
                    Hausfelder[spielernummer][3].BackgroundImage = brett.häuserpool[spielernummer][3].Figurenporträt;
                    Hausfelder[spielernummer][4].BackgroundImage = brett.häuserpool[spielernummer][4].Figurenporträt;
                }

                brett.NochZuGehen--;
                noch_zu_ziehen.Text = ("Du musst noch " + brett.NochZuGehen + " Züge gehen.");
                WurdeFigurAusgewählt = false;
                //GewählteFigur = null;
                //brett.LetztesFeld = null;
                Nachrichtenlabel.Text = "Spieler hat Barrikade versetzt";
                return;
            }

            //Aufnehmen einer Spielfigur
            if (WurdeFigurAusgewählt == false && brett.felderpool[position.X][position.Y].IstBelegt == true
                && brett.felderpool[position.X][position.Y].Spielernummer == brett.WerIstDran)
            {
                Figur gewählteFigur = new Figur(brett.felderpool[position.X][position.Y].Spielernummer, brett.felderpool[position.X][position.Y].Figurnummer);

                gewählteFigur.Im_Haus = brett.figurenpool[brett.felderpool[position.X][position.Y].Spielernummer][brett.felderpool[position.X][position.Y].Figurnummer].Im_Haus;
                gewählteFigur.Position = brett.figurenpool[brett.felderpool[position.X][position.Y].Spielernummer][brett.felderpool[position.X][position.Y].Figurnummer].Position;

                GewählteFigur = gewählteFigur;
                WurdeFigurAusgewählt = true;
                Nachrichtenlabel.Text = "Spielfigur wurde aufgenommen";
                return;
            }

            //Aufgenommene Spielfigur neu platzieren
            if (WurdeFigurAusgewählt == true)
            {
                WurdeFigurAusgewählt = false;

                if (ZieheMitNeuerFigur == false)
                {
                    brett.Move(brett.figurenpool[brett.WerIstDran][brett.felderpool[position.X][position.Y].Figurnummer], brett.felderpool[position.X][position.Y]);
                }
                else
                {
                    for (int figurennummer = 0; figurennummer < 5; figurennummer++)
                    {
                        if (brett.figurenpool[brett.WerIstDran][figurennummer].Im_Haus == false && brett.figurenpool[brett.WerIstDran][figurennummer].X == GewählteFigur.X
                            && brett.figurenpool[brett.WerIstDran][figurennummer].Y == GewählteFigur.Y)
                        {
                            brett.Move(brett.figurenpool[brett.WerIstDran][figurennummer], brett.felderpool[position.X][position.Y]);
                        }
                    }
                }
                
                noch_zu_ziehen.Text = ("Du musst noch " + brett.NochZuGehen + " Züge gehen.");

                Spielfelder[GewählteFigur.X][GewählteFigur.Y].BackgroundImage = brett.felderpool[GewählteFigur.X][GewählteFigur.Y].Feldbild;
                Spielfelder[position.X][position.Y].BackgroundImage = brett.felderpool[position.X][position.Y].Feldbild;

                //Aktualisiert die Hausfelder
                for (int spielernummer = 0; spielernummer < AnzahlDerSpieler; spielernummer++)
                {
                    Hausfelder[spielernummer][0].BackgroundImage = brett.häuserpool[spielernummer][0].Figurenporträt;
                    Hausfelder[spielernummer][1].BackgroundImage = brett.häuserpool[spielernummer][1].Figurenporträt;
                    Hausfelder[spielernummer][2].BackgroundImage = brett.häuserpool[spielernummer][2].Figurenporträt;
                    Hausfelder[spielernummer][3].BackgroundImage = brett.häuserpool[spielernummer][3].Figurenporträt;
                    Hausfelder[spielernummer][4].BackgroundImage = brett.häuserpool[spielernummer][4].Figurenporträt;
                }

                GewählteFigur = null;
                Nachrichtenlabel.Text = "Spielfigur wurde platziert";
                return;
            }
        }

        void Hauptfenster_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            PictureBox picbox = (PictureBox)sender;
            Figurennummerierung hausfeld = (Figurennummerierung)picbox.Tag;

            //Der Spieler hat keine Züge mehr
            if (brett.NochZuGehen == 0)
            { return; }

            if (brett.häuserpool[hausfeld.SpielerNummer][hausfeld.FigurenNummer].IstBelegt == false)
            { return; }     //Auf diesem Hausfeld steht gar keine Figur, die aus ihrem Haus gehen kann!

            if (brett.WerIstDran != hausfeld.SpielerNummer)
            { return; }     //Dieses Haus gehört dem aktuellen Spieler gar nicht!

            if (KamSchonFigurAusHaus == true)
            { return; }     //Der Spieler hat in dieser Runde schon eine Figur aus dem Haus geschickt.

            Spielfelder[brett.figurenpool[hausfeld.SpielerNummer][hausfeld.FigurenNummer].X][brett.figurenpool[hausfeld.SpielerNummer][hausfeld.FigurenNummer].Y].BackgroundImage = brett.figurenpool[hausfeld.SpielerNummer][hausfeld.FigurenNummer].Porträt;
            brett.GeheAusDemHaus(brett.figurenpool[hausfeld.SpielerNummer][hausfeld.FigurenNummer]);
            Hausfelder[hausfeld.SpielerNummer][hausfeld.FigurenNummer].BackgroundImage = brett.häuserpool[hausfeld.SpielerNummer][hausfeld.FigurenNummer].Figurenporträt;
            ZieheMitNeuerFigur = true;
            KamSchonFigurAusHaus = true;
        }

        void DerNächsteBitte()
        {
            brett.WerIstDran++;
            KamSchonFigurAusHaus = false;
            Würfel_but.Enabled = true;
            aktueller_spielername.Text = brett.spielerpool[brett.WerIstDran].Spielername;
            Spieler_pic.BackgroundImage = brett.spielerpool[brett.WerIstDran].Spielerporträt;
        }

        void Würfel_but_Click(object sender, EventArgs e)
        {
            brett.Dice.Würfeln();
            Würfel_pic.BackgroundImage = brett.Dice.GewürfelteFläche;
            noch_zu_ziehen.Text = ("Du musst noch " + brett.NochZuGehen + " Züge gehen.");
            Würfel_but.Enabled = false;
        }

        private void nächster_Click(object sender, EventArgs e)
        {
            if (brett.NochZuGehen == 0)
            {
                DerNächsteBitte();
            }
        }
        
        private void pictureBox1_Click(object sender, EventArgs e)
        {
            Cheatbox cheat = new Cheatbox();
            cheat.ShowDialog();
            if (cheat.Code == "timehole")
            {
                brett.NochZuGehen = 0;
                noch_zu_ziehen.Text = ("Du musst noch " + brett.NochZuGehen + " Züge gehen.");
                brett.spielerpool[brett.WerIstDran].HatBarrikade = false;
                DerNächsteBitte();
            }
            if (cheat.Code == "wormhole")
            {
                brett.figurenpool[brett.WerIstDran][0].Im_Haus = false;
                brett.felderpool[brett.figurenpool[brett.WerIstDran][0].X][brett.figurenpool[brett.WerIstDran][0].Y].IstBelegt = false;
                brett.häuserpool[brett.WerIstDran][0].IstBelegt = false;
                brett.figurenpool[brett.WerIstDran][0].X = 7;
                brett.figurenpool[brett.WerIstDran][0].Y = 12;
                if (brett.felderpool[7][12].IstBelegt == true)
                {
                    brett.häuserpool[brett.felderpool[7][12].Spielernummer][brett.felderpool[7][12].Figurnummer].IstBelegt = true;
                    brett.figurenpool[brett.felderpool[7][12].Spielernummer][brett.felderpool[7][12].Figurnummer].Geschlagen();
                }
                brett.felderpool[7][12].WirdBelegt(brett.figurenpool[brett.WerIstDran][0]);

                for (int spielernummer = 0; spielernummer < AnzahlDerSpieler; spielernummer++)
                {
                    Hausfelder[brett.WerIstDran][0].BackgroundImage = brett.häuserpool[brett.WerIstDran][0].Figurenporträt;
                    Hausfelder[brett.WerIstDran][1].BackgroundImage = brett.häuserpool[brett.WerIstDran][1].Figurenporträt;
                    Hausfelder[brett.WerIstDran][2].BackgroundImage = brett.häuserpool[brett.WerIstDran][2].Figurenporträt;
                    Hausfelder[brett.WerIstDran][3].BackgroundImage = brett.häuserpool[brett.WerIstDran][3].Figurenporträt;
                    Hausfelder[brett.WerIstDran][4].BackgroundImage = brett.häuserpool[brett.WerIstDran][4].Figurenporträt;
                }
                for (int x = 0; x < x_länge; x++)
                {
                    for (int y = 0; y < y_länge; y++)
                    {
                        if (brett.felderpool[x][y].ExistiertDasFeld == false)       //Totes Feld
                        {
                            continue;
                        }
                        Spielfelder[x][y].BackgroundImage = brett.felderpool[x][y].Feldbild;
                        if (brett.felderpool[x][y].IstBelegt == true || brett.felderpool[x][y].IstBlockiert == true)
                        {
                            Spielfelder[x][y].BackgroundImage = brett.felderpool[x][y].Feldbild;
                        }
                    }
                }
            }
        }
    }
}





