﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace Projekt
{
    /// <summary>
    /// sorgt für Datenverkehr (speichern, laden,Filedialog)
    /// </summary>
    public static class FileTransfer
    {
        
        /// <summary>
        /// Speichern einer Instanz als xml
        /// </summary>
        /// <typeparam name="T">Template T wird als XML serialized und gespeichert</typeparam>
        /// <param name="instanz">instanzierte Klasse T</param>
        /// <param name="dateiname">Name der gespeicherten Datei</param>
        public static void QuickSave<T>(T instanz, string dateiname)
        {
            if(!dateiname.Contains(".xml"))
            dateiname += ".xml";

            var fs = File.Create(dateiname);
            try { new XmlSerializer(typeof(T)).Serialize(fs, instanz); }
            catch { }
            finally {fs.Close(); }
        }

        /// <summary>
        /// laedt Daten aus Datei
        /// </summary>
        /// <typeparam name="T">Template T wird geladen und instanziert</typeparam>
        /// <param name="dateiname">zu ladende Datei</param>
        /// <returns></returns>
 
        public static T QuickLoad<T>(string dateiname)
        {
            if (!dateiname.Contains(".xml"))
            dateiname += ".xml";
            T instanz = default(T);
            if (File.Exists(dateiname))
            {
                XmlSerializer xml = new XmlSerializer(typeof(T));
                FileStream fs = File.Open(dateiname, FileMode.Open);
                try { instanz = (T)xml.Deserialize(fs); }
                catch { }
                finally { fs.Close(); }
                
            }
            return instanz;
                                                                                                                                                                                                                                                                                    
        }

        /// <summary>
        /// oeffnet Dialog um einen Dateinamen auszusuchen
        /// </summary>
        /// <param name="option">string text der Box</param>
        /// <returns>string Dateiname</returns>
        public static string ChooseFile(string option)
        {
            
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            openFileDialog1.Filter = "xml files (*.xml)|*.xml|All files (*.*)|*.*";
            openFileDialog1.Title = option;
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
                return openFileDialog1.FileName;
            else
                return string.Empty;
        }

        /// <summary>
        /// überprüft, ob eine File existiert
        /// </summary>
        /// <param name="dateiname"></param>
        /// <returns></returns>
        public static bool FileExist(string dateiname)
        {
            return File.Exists(dateiname);
        }

        /// <summary>
        /// liefert alle FileNamen des übergebenen Ordnernamens
        /// </summary>
        /// <param name="ordnername"></param>
        /// <returns></returns>
        public static string[] GetAllFileNames(string ordnername)
        {
            string[] files = Directory.GetFiles(ordnername);

            for (int i = 0; i < files.Length; i++)
                files[i] = Path.GetFileName(files[i]);

            return files;
        }

        
        }
    }

