﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace Projekt
{
    /// <summary>
    /// erzeugt einen Helden
    /// </summary>
    [Serializable]
    public class Hero  : Status
    {
        
        public Hero()
 
        {
            Attributes[(int)ATTRIBUTES.maxhealth] = 20;
            Health = Attributes[(int)ATTRIBUTES.maxhealth];
            Attributes[(int)ATTRIBUTES.healingpotions] = 2;
            CoordinateX = 0;
            CoordinateY = 0;
        }
        public void Anlegen()
        {
            mem.SetFirstMem();
        }

       

        //----------------------------------------------------------------------
        //----------------- Memory des Helden ---------------------------------
        //----------------------------------------------------------------------

        //anlegen einer Instanz Memory
        Memory mem = new Memory();

        public Memory Mem
        {
            get { return mem; }
            set { mem = value; }
        }

        /// <summary>
        /// dies ändert die Memory eines gewählten Meshes 
        /// </summary>
        /// <param name="level"></param>
        /// <param name="room"></param>
        /// <param name="xcoord"></param>
        /// <param name="ycoord"></param>
        /// <param name="value"></param>
        public void SetMem(int level, int room, int xcoord, int ycoord, int value)
        {
            mem.SetActionMem(xcoord, ycoord, value);
        }

        /// <summary>
        /// Dies lieftert die Memory eines Meshes
        /// </summary>
        /// <param name="level"></param>
        /// <param name="room"></param>
        /// <param name="xcoord"></param>
        /// <param name="ycoord"></param>
        /// <returns></returns>
        public int GetMem(int level, int room, int xcoord, int ycoord)
        {
            return mem.GetActionMem(xcoord, ycoord);
        }

       
        /// <summary>
        /// liefert die Memory des aktuellen Meshes
        /// </summary>
        /// <returns></returns>
        public int GetCurrentMem()
        {
            return this.GetMem(Gamelevel, Room, CoordinateX, CoordinateY);
        }

        public string GetCurrentString()
        {
            int stringnumber =mem.GetStringMem(CoordinateX, CoordinateY);
            return StaticCollect.Currentmesh.Textausgabe[stringnumber];
        }

        //--------------------------------------------------------------------------
        //-------------------- Position des Helden ---------------------------------
        //-------------------------------------------------------------------------
        int gamelevel = 0; //Level in dem sich der Held befindet

        public int Gamelevel
        {
            get { return gamelevel; }
            set { gamelevel = value; }
        }
        
        int room=0; //Raum im dem sich der Held befindet

        public int Room
        {
            get { return room; }
            set { room = value; }
        }
        
        Point coordinate =new Point(); //Koordinate auf der sich der Held befindet

        public Point Coordinate
        {
            get { return coordinate; }
            set { coordinate = value; }
        }

        public int CoordinateX
        {
            get { return coordinate.X; }
            set { coordinate.X = value; }
        }

        public int CoordinateY
        {
            get { return coordinate.Y; }
            set { coordinate.Y = value; }
        }

        //---------------------------------------------------------------------------------
        //------------------------- File Operationen -------------------------------------
        //--------------------------------------------------------------------------------
        
        public void HeroQuickSave(string dateiname) //speichert Instanz Hero als xml
        {
            FileTransfer.QuickSave<Hero>(this, Application.StartupPath + "\\XmlFiles\\Heroes\\" + dateiname);
        }

        public Hero HeroQuickLoad(string dateiname) //laedt xml Datei als Instanz Hero
        {
            return FileTransfer.QuickLoad<Hero>(Application.StartupPath + "\\XmlFiles\\Heroes\\" + dateiname);
        }

        //-----------------------------------------------------------------------------
        //----------------------- Attribute usw des Helden ----------------------------
        //-----------------------------------------------------------------------------
        enum GENDER //Gender, hinzufuegen von neuen Gender ist dynamisch in Code geloest
        {
            Mensch,
            Elf,
            Zwerg,
        };

       
        public string[] GetAllGenderNames() //liefert alle Gender 
        {
            return Enum.GetNames(typeof(GENDER));

        }

        
        int erfahrung;

        public int Erfahrung
        {
            get { return erfahrung; }
            set { erfahrung = value; }
        }

        int nextherolevel;

        public int Nextherolevel
        {
            get { return nextherolevel; }
            set { nextherolevel = 100*(base.Attributes[(int)ATTRIBUTES.level]+1); }
        }

        public void LevelUp()
        {
            base.Attributes[(int)ATTRIBUTES.level] +=(int)Math.Round(((double)(Erfahrung - Nextherolevel) / 100)+0.5,0,MidpointRounding.AwayFromZero);
            this.Nextherolevel = 0;
            base.Attributes[(int)ATTRIBUTES.maxhealth] = (base.Attributes[(int)ATTRIBUTES.level] + 1) * 20;
            Health = base.Attributes[(int)ATTRIBUTES.maxhealth];

        }

        //---------------------------------------------------------------------
        //----------------------- Equipment/Inventar ------------------------
        //--------------------------------------------------------------------

        Equipment equip = new Equipment();

        public Equipment Equip
        {
            get { return equip; }
            set { equip = value; }
        }

        Inventory inv = new Inventory();

        public Inventory Inv
        {
            get { return inv; }
            set { inv = value; }
        }

        
        

    }
}
