﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    /// <summary>
    /// Verantwortlich dafuer, dass der Status des Helden sichtbar ist.
    /// </summary>
    public partial class HeroStatus : UserControl
    {
        Hero hero = new Hero();
        
        public HeroStatus()
        {
            InitializeComponent();
            
        }

        public void SetAvatar() //verantwortlich fuer avatar groupbox
        {
            label_name.Text = hero.Name;
            label_gender.Text = hero.Gender;
            string name = hero.Avatarfile;
            Image ava = Bilder.ResourceManager.GetObject(name) as Bitmap;
            pictureBox1.SizeMode = PictureBoxSizeMode.Zoom;
            pictureBox1.Image = ava;
        }
        
        public void SetHealth() //verantwortlich fuer health groupbox
        {
            int health = hero.Health;
            int maxhealth = hero.AttributeSpecialGet((int)Status.ATTRIBUTES.maxhealth);
            label_health.Text = health.ToString() + "/" + maxhealth ;
            progressBar1.Maximum = maxhealth;
            if (health >= 0)
                progressBar1.Value = health;
            else progressBar1.Value = 0;
        }

        
        
        
        public void SetAttributes()
        {
            flowLayoutPanel_attributes.Controls.Clear();
            string[] attributes = hero.GetAttributesNames();
            int[] attributesvalue = hero.Attributes;
            int zaehler = 0;
            foreach (string str in attributes)
            {
                if (!(str == "maxhealth"))
                {
                    Label lbl = new Label();
                    lbl.Text = str + ": " + (attributesvalue[zaehler]);
                    flowLayoutPanel_attributes.Controls.Add(lbl);
                }
                zaehler++;
            }
        }

        public void SetExperience()
        {
            label_ehrfahrung.Text = hero.Erfahrung.ToString() + "/" + hero.Nextherolevel.ToString();
        }

        public void HeroStatusUpdate()
        {
            hero = StaticCollect.Held;
            label_name.Text = hero.Name;
            label_gender.Text = hero.Gender;
            this.SetHealth();
            this.SetAttributes();
            this.SetAvatar();
            this.SetExperience();
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            (this.Parent as Form1).DefaultScreen();
        }

       

        
        
        
    }
}
