﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace Projekt
{
    /// <summary>
    /// erzeugt ein neues Feld
    /// </summary>
    [Serializable]
    public class Mesh :Room
    {

        public Mesh()
        {

        }

        public Mesh(int x, int y)
        {
            CoordinateX = x;
            CoordinateY = y;
            textausgabe[0] = string.Empty;
        }

        

        private Monster monster = new Monster();

        public Monster Monster
        {
            get { return monster; }
            set { monster = value; }
        }


        int memory; //merkt sich, was im mesh schon passiert ist.

        public int Memory
        {
            get { return memory; }
            set { memory = value; }
        }


        Point coordinate; //Koordinate des Meshes im Raum

        public Point Coordinate
        {
            get { return coordinate; }
            set { coordinate = value; }
        }

        public int CoordinateX
        {
            set { coordinate.X = value; }
            get { return coordinate.X; }
        }

        public int CoordinateY
        {
            set { coordinate.Y = value; }
            get { return coordinate.Y; }
        }
       
        
        bool[] wall=new bool[Enum.GetNames(typeof(StaticCollect.EXPOSITION)).Length]; //true falls Mauer vorhanden

        public bool[] Wall
        {
            get { return wall; }
            set { wall = value; }
        }

        
        public bool WallNorth
        {
            get { return wall[(int)StaticCollect.EXPOSITION.north]; }
            set { wall[(int)StaticCollect.EXPOSITION.north] = value; }
        }

        public bool WallSouth
        {
            get { return wall[(int)StaticCollect.EXPOSITION.south]; }
            set { wall[(int)StaticCollect.EXPOSITION.south] = value; }
        }

        public bool WallWest
        {
            get { return wall[(int)StaticCollect.EXPOSITION.west]; }
            set { wall[(int)StaticCollect.EXPOSITION.west] = value; }
        }

        public bool WallEast
        {
            get { return wall[(int)StaticCollect.EXPOSITION.east]; }
            set { wall[(int)StaticCollect.EXPOSITION.east] = value; }
        }

       
        string[] textausgabe; //enthaelt alle Strings, die in dem Raum noetig sind

        public string[] Textausgabe
        {
            get { return textausgabe; }
            set { textausgabe = value; }
        }

        //-------------------------------------------------------------------
        //------------ Fileoperationen --------------------------------------
        //-------------------------------------------------------------------
        public void MeshQuickSave() //speichert Instanz Mesh als xml
        {

            FileTransfer.QuickSave<Mesh>(this, Application.StartupPath + "\\XmlFiles\\Rooms\\" + "mesh_" + StaticCollect.Currentmesh.CoordinateX + "_" + StaticCollect.Currentmesh.CoordinateY);
        }

        public Mesh MeshQuickLoad(int x, int y) //laedt xml als Instanz Mesh
        {
            return FileTransfer.QuickLoad<Mesh>(Application.StartupPath + "\\XmLFiles\\Rooms\\" + "mesh_" + x + "_" + y);
        }

        public bool MeshExists(int x, int y) //check ob file existiert
        {
            return FileTransfer.FileExist(Application.StartupPath + "\\XmLFiles\\Rooms\\" + "mesh_" + x + "_" + y +".xml");
        }
   
        

    }
}
