﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    public partial class NeuItem : UserControl
    {
        Item item = new Item();
        int attributzaehler = 0;
        string[] attributstring;
        string[] genderstring;

        public NeuItem()
        {
            InitializeComponent();
            foreach (string str in item.GetAllGenderNames())
            {
                listBox_gender.Items.Add(str);
            }
            attributstring = item.GetAttributesNames();
            genderstring = item.GetAllGenderNames();
            label_attributtes.Text += attributstring[0];
            button_neu.Enabled = false;
            groupBox4.Enabled = false;
            avatar("smiley");
        }
        
        //für das ItemBild zuständig
        int zaehler;

        public int Zaehler
        {
            get { return zaehler; }
            set { zaehler = value; }
        }
        
        

        private void button_neu_Click(object sender, EventArgs e)
        {
            if (textBox_name.Text == string.Empty)
            {
                MessageBox.Show("Itemname eingeben", "Fehler");
            }
            else
            {
                item.Name = textBox_name.Text;
                item.Id = listBox_gender.SelectedIndex;
                item.Avatarfile = "Item" + Zaehler;
                
                item.ItemQuickSave(item.Name);
                Close();
            }
        }

        private void button_reset_Click(object sender, EventArgs e)
        {
            attributzaehler = 0;
            label_attributtes.Text = "Attribut: " + attributstring[0];
            button_neu.Enabled = false;
            button_zuweisen.Enabled = true;
            numericUpDown_attribute.Enabled = true;
            groupBox4.Enabled = false;
            avatar("smiley");
            Zaehler = 1;
        }

        private void button_zuweisen_Click(object sender, EventArgs e)
        {
            item.AttributeSpecialSet(attributzaehler, (int)numericUpDown_attribute.Value);
            attributzaehler++;
            if (attributzaehler >= attributstring.Length)
            {
                button_neu.Enabled = true;
                button_zuweisen.Enabled = false;
                label_attributtes.Text = "Attribute vergeben";
                numericUpDown_attribute.Enabled = false;

            }
            else
                label_attributtes.Text = "Attribute " + attributstring[attributzaehler];
             
        }

        private void button_avatar_Click(object sender, EventArgs e)
        {
            Zaehler++;

            string auswahl = listBox_gender.SelectedItem.ToString() + Zaehler;
            avatar(auswahl);
        }

        public void avatar(string name) //Picturebox: picturebox_avatar (noch nicht dynamisch)
        {
            if (Bilder.ResourceManager.GetObject(string.Empty) == Bilder.ResourceManager.GetObject(name))
            {
                Zaehler = 1;
                name = listBox_gender.SelectedItem.ToString() + Zaehler;
            }
            Image avatar = Bilder.ResourceManager.GetObject(name) as Bitmap;
            pictureBox_avatar.SizeMode = PictureBoxSizeMode.Zoom;
            pictureBox_avatar.Image = avatar;
        }

        private void listBox_gender_SelectedIndexChanged(object sender, EventArgs e)
        {
            groupBox4.Enabled = true ; 
            Zaehler = 1;
            string auswahl = listBox_gender.SelectedItem.ToString() + Zaehler;
            avatar(auswahl);
        }

        private void button_close_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Close()
        {
            (this.Parent as Form1).MenuEnable();
            (this.Parent as Form).Controls.Remove(this);
        }





    }
}
