﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Projekt
{
    /// <summary>
    /// Form um neue Monster zu erstellen (noch nicht dynamisch nach gender)
    /// </summary>
    public partial class NeuMonster : UserControl
    {
        Monster monster = new Monster();
        int attributzaehler = 0;
        int avatarzaehler=1;
        string[] attributstring;
       
        public NeuMonster()
        {
           InitializeComponent();
           attributstring = monster.GetAttributesNames();
           label_attributtes.Text += attributstring[0];
           button_neu.Enabled = false;
           avatar("Monster1");
        }

        
        private void button_neu_Click(object sender, EventArgs e) //Clickevent: button_neu (neues Monster anlegen)
        {
            if (textBox_name.Text == string.Empty)
            {
                MessageBox.Show("Monstername eingeben", "Fehler");
            }
            else
            {
                monster.Name = textBox_name.Text;
                monster.Avatarfile = "Monster" + avatarzaehler;
                monster.Health = monster.Attributes[(int)Status.ATTRIBUTES.maxhealth];
                monster.MonsterQuickSave(monster.Name);
                Close();
            }
        }

        private void button_reset_Click(object sender, EventArgs e) //Clickevent: button_reset (reset)
        {
            attributzaehler = 0;
            label_attributtes.Text = "Attribut: " +attributstring[0];
            button_neu.Enabled = false;
            button_zuweisen.Enabled = true;
            numericUpDown_attribute.Enabled = true;
            avatar("Monster1");
            avatarzaehler = 1;

        }

        private void button_zuweisen_Click(object sender, EventArgs e) //Clickevent: button_zuweisen (Wert Attribut zuweisen)
        {
            
            monster.AttributeSpecialSet(attributzaehler, (int)numericUpDown_attribute.Value);
            attributzaehler++;
            if (attributzaehler >= attributstring.Length)
            {
                button_neu.Enabled = true;
                button_zuweisen.Enabled = false;
                label_attributtes.Text = "Attribute vergeben";
                numericUpDown_attribute.Enabled = false;

            }
            else
                label_attributtes.Text = "Attribute "+ attributstring[attributzaehler];
             
            
        }

        private void button_avatar_Click(object sender, EventArgs e) //Clickevent: button_avatar (naechstes Bild)
        {
            avatarzaehler++;
            avatar("Monster"+avatarzaehler);
        }

        public void avatar(string name) //Picturebox: picturebox_avatar (noch nicht dynamisch)
        {
            if (Bilder.ResourceManager.GetObject(string.Empty) == Bilder.ResourceManager.GetObject(name))
            {
                avatarzaehler=1;
                name = "Monster" + 1;
             }
            Image avatar = Bilder.ResourceManager.GetObject(name) as Bitmap;
            pictureBox_avatar.SizeMode = PictureBoxSizeMode.Zoom;
            pictureBox_avatar.Image = avatar;
        }

        

        private void button_close_Click_1(object sender, EventArgs e)
        {
            Close();
               
        }

        private void Close()
        {
            (this.Parent as Form1).MenuEnable();
            (this.Parent as Form).Controls.Remove(this);
        }



       

        

        
    }
}
