﻿using System.Collections.Generic;
using TowerDefence;
using System.Drawing;

/// <summary>
/// Interface to interact with maze solver classes
/// </summary>
interface IMaze
{
    Size GridDim { get; }
    bool TryBuild(Point point);
    bool TryRemove(Point point);
    List<Point> GetPath(MazeStrategy mz);
}

public enum MazeStrategy
{
    Manhattan = 1,
    MaxDXDY = 2,
    DiagonalShortCut = 3,
    Euclidean = 4,
    EuclideanNoSQR = 5,
    Custom1 = 6,
    Air = 7
}