﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace TowerDefence
{
    class Player
    {
        public string Name { get; set; }

        private decimal money;

        public decimal Money
        {
            get { return money; }
            set
            {
                money = value;

                if (PlayerMoneyChanged != null)
                    PlayerMoneyChanged(this, new StateChangedEventArgs(this));
            }
        }

        private int hitPoints;

        public int HitPoints
        {
            get { return hitPoints; }
            set
            {
                hitPoints = value;

                if (PlayerHealthChanged != null)
                    PlayerHealthChanged(this, new StateChangedEventArgs(this));
                if (hitPoints <= 0 && Defeated != null)
                    Defeated(this, new StateChangedEventArgs(this));
            }
        }

        public class StateChangedEventArgs : EventArgs
        {
            public Player Player { get; private set; }
            public StateChangedEventArgs(Player Player)
            {
                this.Player = Player;
            }
        }

        public event EventHandler<StateChangedEventArgs> Defeated;

        public event EventHandler<StateChangedEventArgs> PlayerHealthChanged;

        public event EventHandler<StateChangedEventArgs> PlayerMoneyChanged;

        public Player(string Name = "Player")
        {
            this.Name = Name;
            this.Money = 5M;
            this.HitPoints = 100;
        }

        public void Hit(UnitBase unit)
        {
            HitPoints -= unit.Damage;
        }
    }
}
