﻿
namespace TowerDefence
{
    /// <summary>
    /// wraps wraps SdlDotNet.Audio.Sound instances and provides static sound and music functionality
    /// </summary>
    public class Sound
    {
        private SdlDotNet.Audio.Sound SdlSound { get; set; }

        private string soundFile;

        public string SoundFile
        {
            get { return soundFile; }
            set
            {
                soundFile = value;
                SdlSound = new SdlDotNet.Audio.Sound(Helper.FindFile(SoundFile));
            }
        }

        public Sound(string file)
        {
            SoundFile = file;
        }

        public void Play()
        {
            if (Enabled
                && SdlDotNet.Audio.Mixer.NumberOfChannelsPlaying() < SdlDotNet.Audio.Mixer.ChannelsAllocated
                && SdlSound != null)
            {
                SdlSound.Play();
            }
        }

        static private bool enabled;

        static public bool Enabled
        {
            get { return enabled; }
            set
            {
                if (enabled != value)
                {
                    enabled = value;

                    if (Enabled)
                    {
                        SdlDotNet.Audio.MusicCollection mc = new SdlDotNet.Audio.MusicCollection();
                        mc.Add(new SdlDotNet.Audio.Music(Helper.FindFile("Celestial_Aeon_Project__Burn_them_down.mp3")));
                        mc.Add(new SdlDotNet.Audio.Music(Helper.FindFile("Celestial_Aeon_Project__Hold_the_Line.mp3")));

                        SdlDotNet.Audio.MusicPlayer.EnableMusicFinishedCallback();

                        int currentMusicID = 0;
                        SdlDotNet.Audio.MusicPlayer.Load(mc[currentMusicID]);
                        SdlDotNet.Audio.MusicPlayer.Play();

                        SdlDotNet.Core.Events.MusicFinished += (sender, e) =>
                        {
                            SdlDotNet.Audio.MusicPlayer.Load(mc[currentMusicID++]);
                            if (currentMusicID >= mc.Count)
                                currentMusicID = 0;
                            SdlDotNet.Audio.MusicPlayer.Play();
                        };
                    }
                    else
                    {
                        SdlDotNet.Audio.MusicPlayer.Stop();
                    }
                }
            }
        }

        static Sound()
        {
            Enabled = false;
            SdlDotNet.Audio.Mixer.ChannelsAllocated = 1000;
        }

        /// <summary>
        /// Sets the music volume between 0 and 128
        /// </summary>
        static public int Volume
        {
            get { return SdlDotNet.Audio.MusicPlayer.Volume; }
            set { SdlDotNet.Audio.MusicPlayer.Volume = value; }
        }
    }
}
