﻿using System;
using System.Windows.Forms;

namespace TowerDefence
{
    /// <summary>
    /// settings dialog
    /// </summary>
    public partial class Settings : Form
    {
        public string PlayerName
        {
            get { return textBox1.Text; }
            set { textBox1.Text = value; }
        }

        public class NameChangedEventArgs : EventArgs
        {
            public string Name { get; private set; }
            public NameChangedEventArgs(string name)
            {
                this.Name = name;
            }
        }

        public event EventHandler<NameChangedEventArgs> NameChanged;

        public class SoundSettingsChangedEventArgs : EventArgs
        {
            public bool Enabled { get; private set; }
            public int Volume { get; private set; }
            public SoundSettingsChangedEventArgs(bool Enabled, int Volume)
            {
                this.Enabled = Enabled;
                this.Volume = Volume;
            }
        }

        public event EventHandler<SoundSettingsChangedEventArgs> SoundSettingsChanged;

        public Settings()
        {
            InitializeComponent();

            textBox1.KeyUp += new KeyEventHandler(textBox1_KeyUp);
            textBox1.KeyDown += new KeyEventHandler(textBox1_KeyDown);
        }

        void textBox1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
                this.Close();
        }

        void textBox1_KeyUp(object sender, KeyEventArgs e)
        {
            if (NameChanged != null)
                NameChanged(this, new NameChangedEventArgs(PlayerName));
        }

        private void Settings_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (SoundSettingsChanged != null)
                SoundSettingsChanged(this, new SoundSettingsChangedEventArgs(checkBox2.Checked, trackBar1.Value));
        }

        private void checkBox2_CheckedChanged(object sender, EventArgs e)
        {
            trackBar1.Enabled = checkBox2.Checked;
        }
    }
}
